/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

/* Private Macros ------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uart_handle_t g_h_uart;
pis_modulate_config_t g_modu_conf;
pis_handle_t g_h_pis;

uint8_t g_tx_buf[32] = "essemi UART DEMO: from MCU\r\n";
uint8_t g_rx_buf[32];

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
void uart_pin_init(void)
{
    gpio_init_t x;
    memset(&x, 0x0, sizeof(gpio_init_t));

    /* Initialize tx pin: PC0 */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_CMOS;
    x.func = GPIO_FUNC_3;
    ald_gpio_init(UART_TX_PORT, UART_TX_PIN, &x);

    /* Initialize rx pin: PC1 */
    x.mode = GPIO_MODE_INPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_CMOS;
    x.func = GPIO_FUNC_3;
    ald_gpio_init(UART_RX_PORT, UART_RX_PIN, &x);

    return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_send_complete(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_recv_complete(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_error(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Initialize TIMER.
  * @param  None
  * @retval None
  */
void timer_init(void)
{
    timer_handle_t h_tim;
    timer_oc_init_t tim_ocinit;
    memset(&h_tim, 0x0, sizeof(timer_handle_t));
    memset(&tim_ocinit, 0x0, sizeof(timer_oc_init_t));

    /* Initialize Timer */
    h_tim.perh           = TIMER0;
    h_tim.init.prescaler = 0;
    h_tim.init.mode      = TIMER_CNT_MODE_UP;
    h_tim.init.period    = 1270;
    h_tim.init.clk_div   = TIMER_CLOCK_DIV1;
    h_tim.init.re_cnt    = 0;
    ald_timer_pwm_init(&h_tim);

    /* Common configuration for channel 1 */
    tim_ocinit.oc_mode      = TIMER_OC_MODE_PWM1;
    tim_ocinit.oc_polarity  = TIMER_OC_POLARITY_HIGH;
    tim_ocinit.oc_fast_en   = DISABLE;
    tim_ocinit.ocn_polarity = TIMER_OCN_POLARITY_HIGH;
    tim_ocinit.ocn_idle     = TIMER_OCN_IDLE_RESET;
    tim_ocinit.pulse = 635;
    ald_timer_oc_config_channel(&h_tim, &tim_ocinit, TIMER_CHANNEL_1);

    /* Start input pwm from tim0 channel 1 */
    ald_timer_oc_start(&h_tim, TIMER_CHANNEL_1);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint8_t tx_len = strlen((char *) g_tx_buf);
    uint8_t rx_len = sizeof(g_rx_buf);

    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
    ald_mcu_irq_config(UART1_IRQn, 3, 3, ENABLE);

    memset(&g_modu_conf, 0x0, sizeof(pis_modulate_config_t));
    memset(&g_h_uart, 0x0, sizeof(uart_handle_t));

    g_h_pis.perh        = PIS;
    g_modu_conf.target  = PIS_UART1_TX;
    g_modu_conf.src     = PIS_SRC_TIMER0;
    g_modu_conf.level   = PIS_LOW_LEVEL;
    g_modu_conf.channel = PIS_TIMER_CH1;
    ald_pis_modu_config(&g_h_pis, &g_modu_conf);

    timer_init();

    /* Initialize pin */
    uart_pin_init();

    /* Initialize uart */
    g_h_uart.perh             = UART1;
    g_h_uart.init.baud        = 2400;
    g_h_uart.init.word_length = UART_WORD_LENGTH_8B;
    g_h_uart.init.stop_bits   = UART_STOP_BITS_1;
    g_h_uart.init.parity      = UART_PARITY_NONE;
    g_h_uart.init.mode        = UART_MODE_UART;
    g_h_uart.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&g_h_uart);

    ald_uart_rx_fifo_config(&g_h_uart, UART_RXFIFO_1BYTE);
    ald_uart_tx_fifo_config(&g_h_uart, UART_TXFIFO_EMPTY);

    ald_uart_send_by_it(&g_h_uart, g_tx_buf, tx_len);
    ald_uart_recv_by_it(&g_h_uart, g_rx_buf, rx_len);

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
