/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uart_handle_t g_uart0_init;
uart_handle_t g_uart1_init;

char g_tx0_buf[256] = "UART0 : ";
char g_tx1_buf[256] = "UART1 : ";
uint8_t g_tx0_len ;
uint8_t g_tx1_len ;

uint8_t g_rx0_buf[256];
uint32_t g_rx0_len = sizeof(g_rx0_buf);
uint8_t g_rx1_buf[256];
uint32_t g_rx1_len = sizeof(g_rx1_buf);

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
void init_uart_pin(void)
{
    gpio_init_t gpio_init;
    memset(&gpio_init, 0x00, sizeof(gpio_init_t));

    /* Initialize tx0 pin: PB10 */
    gpio_init.mode = GPIO_MODE_OUTPUT;
    gpio_init.odos = GPIO_OPEN_DRAIN;
    gpio_init.pupd = GPIO_PUSH_UP;
    gpio_init.podrv = GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_init.flt  = GPIO_FILTER_DISABLE;
    gpio_init.type = GPIO_TYPE_CMOS;
    gpio_init.func = GPIO_FUNC_3;
    ald_gpio_init(UART0_TX_PORT, UART0_TX_PIN, &gpio_init);

    /* Initialize rx0 pin: PB11 */
    gpio_init.mode = GPIO_MODE_INPUT;
    gpio_init.odos = GPIO_OPEN_DRAIN;
    gpio_init.pupd = GPIO_PUSH_UP;
    gpio_init.podrv = GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_init.flt  = GPIO_FILTER_DISABLE;
    gpio_init.type = GPIO_TYPE_CMOS;
    gpio_init.func = GPIO_FUNC_3;
    ald_gpio_init(UART0_RX_PORT, UART0_RX_PIN, &gpio_init);

    /* Initialize tx1 pin: PC0 */
    gpio_init.mode = GPIO_MODE_OUTPUT;
    gpio_init.odos = GPIO_OPEN_DRAIN;
    gpio_init.pupd = GPIO_PUSH_UP;
    gpio_init.podrv = GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_init.flt  = GPIO_FILTER_DISABLE;
    gpio_init.type = GPIO_TYPE_CMOS;
    gpio_init.func = GPIO_FUNC_3;
    ald_gpio_init(UART1_TX_PORT, UART1_TX_PIN, &gpio_init);

    /* Initialize rx1 pin: PC1 */
    gpio_init.mode = GPIO_MODE_INPUT;
    gpio_init.odos = GPIO_OPEN_DRAIN;
    gpio_init.pupd = GPIO_PUSH_UP;
    gpio_init.podrv = GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_init.flt  = GPIO_FILTER_DISABLE;
    gpio_init.type = GPIO_TYPE_CMOS;
    gpio_init.func = GPIO_FUNC_3;
    ald_gpio_init(UART1_RX_PORT, UART1_RX_PIN, &gpio_init);

    return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart0_send_complete(uart_handle_t *arg)
{
    return;
}
/**
  * @brief  Send message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */

void uart1_send_complete(uart_handle_t *arg)
{
    return;
}
/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart0_recv_complete(uart_handle_t *arg)
{
    static uint8_t s_i = 0;

    if ((s_i > 1) && (*(g_uart0_init.rx_buf - 2) == 0x0D) && (*(g_uart0_init.rx_buf  - 1) == 0x0A))
    {
        memcpy(g_tx0_buf + g_tx0_len, g_rx0_buf, s_i);
        ald_uart_send_by_it(&g_uart0_init, (uint8_t *)g_tx0_buf, g_tx0_len + s_i);
        ald_uart_recv_by_it(&g_uart0_init, g_rx0_buf, 1);
        s_i = 0;
    }
    else
    {
        if (s_i >= g_rx0_len)
            s_i = 0;

        ald_uart_recv_by_it(&g_uart0_init, g_rx0_buf + s_i, 1);
        s_i++;
    }

    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart1_recv_complete(uart_handle_t *arg)
{
    static uint8_t s_i = 0;

    if ((s_i > 1) && (*(g_uart1_init.rx_buf - 2) == 0x0D) && (*(g_uart1_init.rx_buf - 1) == 0x0A))
    {
        memcpy(g_tx1_buf + g_tx1_len, g_rx1_buf, s_i);
        ald_uart_send_by_it(&g_uart1_init, (uint8_t *)g_tx1_buf, g_tx1_len + s_i);
        s_i = 0;
        ald_uart_recv_by_it(&g_uart1_init, g_rx1_buf, 1);

    }
    else
    {
        if (s_i >= g_rx1_len)
            s_i = 0;

        ald_uart_recv_by_it(&g_uart1_init, g_rx1_buf + s_i, 1);
        s_i++;
    }

    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_error(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Initializate uart module.
  * @retval None
  */
void init_uart(void)
{
    uart_rs485_config_t rs485_config0, rs485_config1;

    memset(&g_uart0_init, 0x00, sizeof(uart_handle_t));
    /* Initialize uart0 */
    g_uart0_init.perh             = UART0;
    g_uart0_init.init.baud        = 9600;
    g_uart0_init.init.word_length = UART_WORD_LENGTH_8B;
    g_uart0_init.init.stop_bits   = UART_STOP_BITS_1;
    g_uart0_init.init.parity      = UART_PARITY_NONE;
    g_uart0_init.init.mode        = UART_MODE_RS485;
    g_uart0_init.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    g_uart0_init.rx_cplt_cbk      = uart0_recv_complete;
    ald_uart_init(&g_uart0_init);

    rs485_config0.normal = DISABLE;
    rs485_config0.dir    = DISABLE;
    rs485_config0.invert = DISABLE;
    rs485_config0.addr   = 0xF;
    ald_uart_rs485_config(&g_uart0_init, &rs485_config0);

    memset(&g_uart1_init, 0x00, sizeof(uart_handle_t));
    /* Initialize uart1 */
    g_uart1_init.perh             = UART1;
    g_uart1_init.init.baud        = 9600;
    g_uart1_init.init.word_length = UART_WORD_LENGTH_8B;
    g_uart1_init.init.stop_bits   = UART_STOP_BITS_1;
    g_uart1_init.init.parity      = UART_PARITY_NONE;
    g_uart1_init.init.mode        = UART_MODE_RS485;
    g_uart1_init.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    g_uart1_init.rx_cplt_cbk      = uart1_recv_complete;
    ald_uart_init(&g_uart1_init);

    rs485_config1.normal = DISABLE;
    rs485_config1.dir    = DISABLE;
    rs485_config1.invert = DISABLE;
    rs485_config1.addr   = 0x1;
    ald_uart_rs485_config(&g_uart1_init, &rs485_config1);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
    ald_mcu_irq_config(UART0_IRQn, 2, 2, ENABLE);
    ald_mcu_irq_config(UART1_IRQn, 3, 3, ENABLE);

    /* Initialize pin */
    init_uart_pin();

    /* Initialize uart */
    init_uart();

    ald_uart_rx_fifo_config(&g_uart0_init, UART_RXFIFO_1BYTE);
    ald_uart_tx_fifo_config(&g_uart0_init, UART_TXFIFO_EMPTY);
    ald_uart_rx_fifo_config(&g_uart1_init, UART_RXFIFO_1BYTE);
    ald_uart_tx_fifo_config(&g_uart1_init, UART_TXFIFO_EMPTY);

    ald_uart_recv_by_it(&g_uart0_init, g_rx0_buf, 1);
    ald_uart_recv_by_it(&g_uart1_init, g_rx1_buf, 1);

    g_tx0_len = strlen(g_tx0_buf);
    g_tx1_len = strlen(g_tx1_buf);

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
