/**********************************************************************************
 *
 * @file    main.c
 * @brief   6pwm C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initialize GPIO for 6 PWM funtion
  * @param  None
  * @retval None
  */
void init_gpio(void)
{
    md_gpio_init_t gpio_init;

    md_gpio_init_struct(&gpio_init);
    gpio_init.func = MD_GPIO_FUNC_2;
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_FLOATING;
    md_gpio_init(CH1_PORT, CH1_PIN, &gpio_init);
    md_gpio_init(CH1N_PORT, CH1N_PIN, &gpio_init);
    md_gpio_init(CH2_PORT, CH2_PIN, &gpio_init);
    md_gpio_init(CH3_PORT, CH3_PIN, &gpio_init);

    md_gpio_init_struct(&gpio_init);
    gpio_init.func = MD_GPIO_FUNC_3;
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_FLOATING;
    md_gpio_init(CH2N_PORT, CH2N_PIN, &gpio_init);
    md_gpio_init(CH3N_PORT, CH3N_PIN, &gpio_init);
}

/**
  * @brief:  Initialize AD16C4T to 6 PWM funtion
  * @param:  None
  * @retval: None
  */
static void init_timer(void)
{

    md_timer_base_init_t ad16c4t_init;
    md_timer_oc_init_t oc_init;

    md_timer_base_struct_init(&ad16c4t_init);
    ad16c4t_init.prescaler = 0;
    ad16c4t_init.clk_div = MD_TIMER_CLOCK_DIV1;     /* working clock of dead time and filter */
    ad16c4t_init.mode = MD_TIMER_CNT_MODE_CENTER1;  /* count mode is center1 */
    ad16c4t_init.period = 36000 - 1;                /* period is 36000 count clock */
    ad16c4t_init.re_cnt = 0;                        /* no repeat count */
    md_timer_base_set_config(AD16C4T1, &ad16c4t_init);
    md_timer_oc_struct_init(&oc_init);
    oc_init.ocstate = MD_TIMER_OCSTATE_ENABLE;    /* enable CHxO compare output */
    oc_init.ocnstate = MD_TIMER_OCSTATE_ENABLE;   /* enable CHxON compare output */
    oc_init.oc_mode = MD_TIMER_OC_MODE_PWM2;      /* compare output mode is PWM2 */
    oc_init.oc_polarity = MD_TIMER_OC_POLARITY_HIGH;    /* CHxO compare output polarity is high */
    oc_init.ocn_polarity = MD_TIMER_OCN_POLARITY_HIGH;  /* CHxON compare output polarity is high */
    oc_init.oc_idle = MD_TIMER_OC_IDLE_RESET;           /* CHxO idle is low */
    oc_init.ocn_idle = MD_TIMER_OCN_IDLE_RESET;         /* CHxON idle is low */
    oc_init.pulse = 10000 - 1;    /* CH1 compare value is 10000 - 1 */
    md_timer_oc_init(AD16C4T1, MD_TIMER_CHANNEL_1, &oc_init);
    oc_init.pulse = 20000 - 1;    /* CH2 compare value is 20000 - 1 */
    md_timer_oc_init(AD16C4T1, MD_TIMER_CHANNEL_2, &oc_init);
    oc_init.pulse = 30000 - 1;    /* CH3 compare value is 30000 - 1 */
    md_timer_oc_init(AD16C4T1, MD_TIMER_CHANNEL_3, &oc_init);

    md_timer_enable_cc1it_interrupt(AD16C4T1);   /* enable CC1 interrupt request */
    md_timer_enable_cc2it_interrupt(AD16C4T1);   /* enable CC2 interrupt request */
    md_timer_enable_cc3it_interrupt(AD16C4T1);   /* enable CC3 interrupt request */
    md_timer_enable_uit_interrupt(AD16C4T1);     /* update interrupt request */

    md_mcu_irq_config(AD16C4T1_UP_IRQn, 0, 0, ENABLE);  /* enable NVIC AD16C4T1 updata interrupt */
    md_mcu_irq_config(AD16C4T1_CC_IRQn, 0, 0, ENABLE);  /* enable NVIC AD16C4T1 capture and compare interrupt */

    md_timer_enable_counter_cnten(AD16C4T1);            /* enable AD16C4T1 */
    md_timer_set_main_output_enable(AD16C4T1, 1);       /* enable output */
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HRC_6, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);
    /* Initialize pin */
    init_gpio();
    /* Initialize timer */
    init_timer();

    while (1)
    {
        md_delay_1ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
