/**********************************************************************************
 *
 * @file    main.c
 * @brief   motor_svpwm C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Variables --------------------------------------------------------- */
uint16_t g_hTime_25ms = 50U;
uint8_t  g_hfDir;
uint16_t g_Acnt;
uint16_t g_Bcnt;
uint16_t g_Ccnt;
uint16_t g_Elec_Angle = 0U;
int16_t  g_hVolt_Percent = 14999;    /* %95 */
/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Public Variables ---------------------------------------------------------- */

timer_handle_t g_ad16c4t_init;
timer_oc_init_t g_oc_init;
gpio_init_t g_gpio_init;
timer_clock_config_t g_ad16c4t_clock_config;
dac_handle_t g_h_dac;
uint32_t g_hDAC_Val;

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  ald timer compare elapsed callback
  * @param  arg: Pointer to timer_handle_t structure.
  * @retval None.
  */
void ald_timer_compare_callback(struct timer_handle_s *arg)
{
    switch (arg->ch)
    {
        case TIMER_ACTIVE_CHANNEL_1:
            __NOP();
            break;

        case TIMER_ACTIVE_CHANNEL_2:
            __NOP();
            break;

        case TIMER_ACTIVE_CHANNEL_3:
            __NOP();
            break;

        case TIMER_ACTIVE_CHANNEL_4:
            __NOP();
            break;

        default:
            break;
    }
}

/**
  * @brief  ald timer period elapsed callback
  * @param  arg: Pointer to timer_handle_t structure.
  * @retval None.
  */
void ald_timer_period_elapsed_callback(struct timer_handle_s *arg)
{
    g_Elec_Angle += 30;
    Cal_SVPWM(g_hVolt_Percent, g_Elec_Angle);
    ald_dac_output_set(&g_h_dac, DAC_CHANNEL_0, g_Acnt);
    ald_dac_output_set(&g_h_dac, DAC_CHANNEL_1, g_Bcnt);
}

/**
  * @brief  Initialize GPIO for 6 PWM and break in funtion
  * @param  None
  * @retval None
  */
void init_gpio(void)
{
    /* Initialize P as input */
    memset(&g_gpio_init, 0x0, sizeof(g_gpio_init));
    g_gpio_init.mode = GPIO_MODE_OUTPUT;
    g_gpio_init.odos = GPIO_PUSH_PULL;
    g_gpio_init.flt  = GPIO_FILTER_DISABLE;
    g_gpio_init.type = GPIO_TYPE_CMOS;
    g_gpio_init.func = GPIO_FUNC_2;
    ald_gpio_init(CH1_PORT, CH1_PIN, &g_gpio_init);
    ald_gpio_init(CH1N_PORT, CH1N_PIN, &g_gpio_init);
    ald_gpio_init(CH2_PORT, CH2_PIN, &g_gpio_init);
    ald_gpio_init(CH3_PORT, CH3_PIN, &g_gpio_init);

    memset(&g_gpio_init, 0x0, sizeof(g_gpio_init));
    g_gpio_init.mode = GPIO_MODE_OUTPUT;
    g_gpio_init.odos = GPIO_PUSH_PULL;
    g_gpio_init.flt  = GPIO_FILTER_DISABLE;
    g_gpio_init.type = GPIO_TYPE_CMOS;
    g_gpio_init.func = GPIO_FUNC_3;
    ald_gpio_init(CH2N_PORT, CH2N_PIN, &g_gpio_init);
    ald_gpio_init(CH3N_PORT, CH3N_PIN, &g_gpio_init);

    /* DAC pin Initialize */
    memset(&g_gpio_init, 0, sizeof(gpio_init_t));
    g_gpio_init.mode = GPIO_MODE_OUTPUT;
    g_gpio_init.func = GPIO_FUNC_0;
    ald_gpio_init(DAC0_OUT_PORT, DAC0_OUT_PIN1, &g_gpio_init);
    ald_gpio_init(DAC0_OUT_PORT, DAC0_OUT_PIN2, &g_gpio_init);
}

/**
  * @brief:  Initialize AD16C4T to 6 PWM funtion
  * @param:  None
  * @retval: None
  */
static void init_timer(void)
{
    /* Initialize AD16C4T1 */
    memset(&g_ad16c4t_init, 0x0, sizeof(g_ad16c4t_init));
    g_ad16c4t_init.perh              = AD16C4T1;
    g_ad16c4t_init.init.prescaler    = 0;                      /* clk_count: 36MHz */
    g_ad16c4t_init.init.mode         = TIMER_CNT_MODE_CENTER1; /* count mode is center1 */
    g_ad16c4t_init.init.period       = PWM_PERIOD - 1;             /* period is 36000 count clock */
    g_ad16c4t_init.init.clk_div      = TIMER_CLOCK_DIV1;       /* working clock of dead time and filter */
    g_ad16c4t_init.init.re_cnt       = 1;                      /* no repeat count */
    g_ad16c4t_init.delay_elapse_cbk  = ald_timer_compare_callback; /* compare elapsed callback */
    g_ad16c4t_init.period_elapse_cbk = ald_timer_period_elapsed_callback;
    ald_timer_oc_init(&g_ad16c4t_init);

    /* Initialize clock source */
    g_ad16c4t_clock_config.source = TIMER_SRC_INTER;   /* clock sources is internal */
    ald_timer_config_clock_source(&g_ad16c4t_init, &g_ad16c4t_clock_config);

    /* Compare output configuration for all channels */
    memset(&g_oc_init, 0x0, sizeof(g_oc_init));
    g_oc_init.oc_mode      = TIMER_OC_MODE_PWM1;      /* compare output mode is PWM2 */
    g_oc_init.oc_polarity  = TIMER_OC_POLARITY_LOW;  /* CHxO compare output polarity is high */
    g_oc_init.ocn_polarity = TIMER_OCN_POLARITY_LOW; /* CHxON compare output polarity is high */
    g_oc_init.ocn_idle     = TIMER_OCN_IDLE_SET;    /* CHxO idle is low */
    g_oc_init.oc_idle      = TIMER_OC_IDLE_SET;     /* CHxON idle is low */
    g_oc_init.pulse        = 0x505;

    ald_timer_oc_config_channel(&g_ad16c4t_init, &g_oc_init, TIMER_CHANNEL_1);
    ald_timer_oc_config_channel(&g_ad16c4t_init, &g_oc_init, TIMER_CHANNEL_2);
    ald_timer_oc_config_channel(&g_ad16c4t_init, &g_oc_init, TIMER_CHANNEL_3);

    /* Start compare output from channel X and XN */
    ald_timer_oc_start(&g_ad16c4t_init, TIMER_CHANNEL_1);
    ald_timer_oc_start(&g_ad16c4t_init, TIMER_CHANNEL_2);
    ald_timer_oc_start(&g_ad16c4t_init, TIMER_CHANNEL_3);
    ald_timer_ocn_start(&g_ad16c4t_init, TIMER_CHANNEL_1);
    ald_timer_ocn_start(&g_ad16c4t_init, TIMER_CHANNEL_2);
    ald_timer_ocn_start(&g_ad16c4t_init, TIMER_CHANNEL_3);

    /* Enable NVIC GP16C4T1 CC interrupt */
    ald_mcu_irq_config(AD16C4T1_UP_IRQn, 0, 0, ENABLE);
    ald_timer_clear_flag_status(&g_ad16c4t_init, TIMER_FLAG_UPDATE);
    ald_timer_interrupt_config(&g_ad16c4t_init, TIMER_IT_UPDATE, ENABLE);
}

/**
  * @brief:  Initialize system clock funtion
  * @param:  None
  * @retval: None
  */
static void System_Clock(void)
{
    /* Initialize ALD */
    ald_cmu_init();

    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
}

/**
  * @brief:  Initialize DAC funtion
  * @param:  None
  * @retval: None
  */
static void Init_DAC(void)
{
    uint16_t cnt;
    dac_channel_config_t channel_config;
    /* Initialize DAC */
    memset(&g_h_dac, 0, sizeof(dac_handle_t));
    g_h_dac.perh            = DAC0;
    g_h_dac.init.conv_mode  = DAC_CONV_MODE_CONTINUOUS;
    g_h_dac.init.out_mode   = DAC_OUTPUT_PIN;
    g_h_dac.init.refresh    = DAC_REFRESH_8;
    g_h_dac.init.div        = DAC_PRES_DIV_64;
    g_h_dac.init.ch0_reset  = DISABLE;
    g_h_dac.init.o_ctrl_pis = DISABLE;
    g_h_dac.init.sine       = DISABLE;
    g_h_dac.init.diff       = DISABLE;
    g_h_dac.init.n_ref      = DAC_NEG_REF_VSS;
    g_h_dac.init.p_ref      = DAC_POS_REF_VDD;
    ald_dac_init(&g_h_dac);

    /* Config dac channel 0-1 */
    channel_config.enable     = ENABLE;
    channel_config.trigger    = DAC_TRIGGER_BY_DATA;
    channel_config.refresh_en = DISABLE;
    ald_dac_channel_config(&g_h_dac, &channel_config, DAC_CHANNEL_0);
    ald_dac_channel_config(&g_h_dac, &channel_config, DAC_CHANNEL_1);

    g_hDAC_Val = 4095;
    ald_dac_output_set(&g_h_dac, DAC_CHANNEL_0, 4095);

    cnt = 4000;

    while (ald_dac_get_status(&g_h_dac, DAC_CH0_BSY) && (--cnt));
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize Clock */
    System_Clock();

    /* Initialize pin */
    init_gpio();

    /* Initialize timer */
    init_timer();

    /* Initialize DAC*/
    Init_DAC();

    while (1)
    {
        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
