/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "string.h"
#include "ald_conf.h"
#include "svpwm.h"

/* Exported Macros ----------------------------------------------------------- */

#define CKTIM   ((uint32_t)72000000uL)
#define PWM_PRSC   ((uint8_t)0)
#define PWM_FREQ   ((uint16_t) 16000)                /* 16khz */
#define PWM_PERIOD ((uint16_t) (CKTIM / (uint32_t)(2 * PWM_FREQ *(PWM_PRSC+1))))

/* Exported Variables -------------------------------------------------------- */
extern timer_handle_t g_ad16c4t_init;
extern dac_handle_t g_h_dac;
extern uint32_t g_hDAC_Val;
extern uint16_t g_hTime_25ms;
extern uint8_t  g_hfDir;
extern uint16_t g_Acnt;
extern uint16_t g_Bcnt;
extern uint16_t g_Ccnt;
extern uint16_t g_Elec_Angle;
extern int16_t g_hVolt_Percent;

#define CH1_PORT    GPIOC
#define CH1_PIN     GPIO_PIN_6
#define CH1N_PORT   GPIOA
#define CH1N_PIN    GPIO_PIN_7

#define CH2_PORT    GPIOC
#define CH2_PIN     GPIO_PIN_7
#define CH2N_PORT   GPIOB
#define CH2N_PIN    GPIO_PIN_0

#define CH3_PORT    GPIOC
#define CH3_PIN     GPIO_PIN_8
#define CH3N_PORT   GPIOB
#define CH3N_PIN    GPIO_PIN_1

#define DAC0_OUT_PORT   GPIOA
#define DAC0_OUT_PIN1   GPIO_PIN_4
#define DAC0_OUT_PIN2   GPIO_PIN_5

/* Exported Constants ------------------------------------------------------- */
/* Exported Functions ------------------------------------------------------ */
/* Exported Types ---------------------------------------------------------- */

#endif /*__MAIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
