/**********************************************************************************
 *
 * @file    main.c
 * @brief   6pwm C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Variables --------------------------------------------------------- */
/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Public Variables ---------------------------------------------------------- */

timer_handle_t g_ad16c4t_init;
gpio_init_t g_gpio_init;
timer_clock_config_t g_ad16c4t_clock_config;

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  ald timer compare elapsed callback
  * @param  arg: Pointer to timer_handle_t structure.
  * @retval None.
  */
void ald_timer_compare_callback(struct timer_handle_s *arg)
{
    switch (arg->ch)
    {
        case TIMER_ACTIVE_CHANNEL_1:
            __NOP();
            break;

        case TIMER_ACTIVE_CHANNEL_2:
            __NOP();
            break;

        case TIMER_ACTIVE_CHANNEL_3:
            __NOP();
            break;

        case TIMER_ACTIVE_CHANNEL_4:
            __NOP();
            break;

        default:
            break;
    }
}

/**
  * @brief  Initialize GPIO for 6 PWM and break in funtion
  * @param  None
  * @retval None
  */
void init_gpio(void)
{
    /* Initialize P as input */
    memset(&g_gpio_init, 0x0, sizeof(g_gpio_init));
    g_gpio_init.mode = GPIO_MODE_OUTPUT;
    g_gpio_init.odos = GPIO_PUSH_PULL;
    g_gpio_init.flt  = GPIO_FILTER_DISABLE;
    g_gpio_init.type = GPIO_TYPE_CMOS;
    g_gpio_init.func = GPIO_FUNC_2;
    ald_gpio_init(CH1_PORT, CH1_PIN, &g_gpio_init);
    ald_gpio_init(CH1N_PORT, CH1N_PIN, &g_gpio_init);
    ald_gpio_init(CH2_PORT, CH2_PIN, &g_gpio_init);
    ald_gpio_init(CH3_PORT, CH3_PIN, &g_gpio_init);

    memset(&g_gpio_init, 0x0, sizeof(g_gpio_init));
    g_gpio_init.mode = GPIO_MODE_OUTPUT;
    g_gpio_init.odos = GPIO_PUSH_PULL;
    g_gpio_init.flt  = GPIO_FILTER_DISABLE;
    g_gpio_init.type = GPIO_TYPE_CMOS;
    g_gpio_init.func = GPIO_FUNC_3;
    ald_gpio_init(CH2N_PORT, CH2N_PIN, &g_gpio_init);
    ald_gpio_init(CH3N_PORT, CH3N_PIN, &g_gpio_init);
}

/**
  * @brief:  Initialize AD16C4T to 6 PWM funtion
  * @param:  None
  * @retval: None
  */
static void init_timer(void)
{
    timer_oc_init_t oc_init;

    /* Initialize AD16C4T1 */
    memset(&g_ad16c4t_init, 0x0, sizeof(g_ad16c4t_init));
    g_ad16c4t_init.perh = AD16C4T1;
    g_ad16c4t_init.init.prescaler    = 1;                      /* clk_count: 36MHz */
    g_ad16c4t_init.init.mode         = TIMER_CNT_MODE_CENTER1; /* count mode is center1 */
    g_ad16c4t_init.init.period       = 36000 - 1;              /* period is 36000 count clock */
    g_ad16c4t_init.init.clk_div      = TIMER_CLOCK_DIV1;       /* working clock of dead time and filter */
    g_ad16c4t_init.init.re_cnt       = 0;                      /* no repeat count */
    g_ad16c4t_init.delay_elapse_cbk = ald_timer_compare_callback; /* compare elapsed callback */
    ald_timer_oc_init(&g_ad16c4t_init);

    /* Initialize clock source */
    g_ad16c4t_clock_config.source = TIMER_SRC_INTER;   /* clock sources is internal */
    ald_timer_config_clock_source(&g_ad16c4t_init, &g_ad16c4t_clock_config);

    /* Compare output configuration for all channels */
    memset(&oc_init, 0x0, sizeof(oc_init));
    oc_init.oc_mode      = TIMER_OC_MODE_PWM2;      /* compare output mode is PWM2 */
    oc_init.oc_polarity  = TIMER_OC_POLARITY_HIGH;  /* CHxO compare output polarity is high */
    oc_init.ocn_polarity = TIMER_OCN_POLARITY_HIGH; /* CHxON compare output polarity is high */
    oc_init.ocn_idle     = TIMER_OCN_IDLE_RESET;    /* CHxO idle is low */
    oc_init.oc_idle      = TIMER_OC_IDLE_RESET;     /* CHxON idle is low */

    /* Set the compare value for channel 1 */
    oc_init.pulse = 10000 - 1;
    ald_timer_oc_config_channel(&g_ad16c4t_init, &oc_init, TIMER_CHANNEL_1);
    /* Set the compare value for channel 2 */
    oc_init.pulse = 20000 - 1;
    ald_timer_oc_config_channel(&g_ad16c4t_init, &oc_init, TIMER_CHANNEL_2);
    /* Set the compare value for channel 3 */
    oc_init.pulse = 30000 - 1;
    ald_timer_oc_config_channel(&g_ad16c4t_init, &oc_init, TIMER_CHANNEL_3);

    /* Start compare output from channel 1 */
    ald_timer_oc_start_by_it(&g_ad16c4t_init, TIMER_CHANNEL_1);
    /* Start compare output from channel 2 */
    ald_timer_oc_start_by_it(&g_ad16c4t_init, TIMER_CHANNEL_2);
    /* Start compare output from channel 3 */
    ald_timer_oc_start_by_it(&g_ad16c4t_init, TIMER_CHANNEL_3);
    /* Start compare output from channel 1N */
    ald_timer_ocn_start_by_it(&g_ad16c4t_init, TIMER_CHANNEL_1);
    /* Start compare output from channel 2N */
    ald_timer_ocn_start_by_it(&g_ad16c4t_init, TIMER_CHANNEL_2);
    /* Start compare output from channel 3N */
    ald_timer_ocn_start_by_it(&g_ad16c4t_init, TIMER_CHANNEL_3);

    /* Enable NVIC GP16C4T1 CC interrupt */
    ald_mcu_irq_config(AD16C4T1_CC_IRQn, 0, 0, ENABLE);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Initialize pin */
    init_gpio();

    /* Initialize timer */
    init_timer();

    while (1)
    {
        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
