/**********************************************************************************
 *
 * @file    main.c
 * @brief   external_counting C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Variables --------------------------------------------------------- */
/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Public Variables ---------------------------------------------------------- */

timer_handle_t g_ad16c4t_init;
gpio_init_t g_gpio_init;
timer_clock_config_t g_ad16c4t_clock_config;


/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initialize TOGGLE IO and AD16C4T1 TE IO
  * @param  None
  * @retval None
  */
void init_gpio(void)
{
    /* Initialize TOGGLE IO as output */
    memset(&g_gpio_init, 0x0, sizeof(g_gpio_init)); /* initialize the g_gpio_init */
    g_gpio_init.mode = GPIO_MODE_OUTPUT;            /* output */
    g_gpio_init.odos = GPIO_PUSH_PULL;              /* push pull */
    g_gpio_init.pupd = GPIO_FLOATING;               /* no pull up and pull donw */
    g_gpio_init.func = GPIO_FUNC_1;                 /* GPIO function 1 */
    ald_gpio_init(TOGGLE_PORT, TOGGLE_PIN, &g_gpio_init);

    /* Initialize TE IO */
    memset(&g_gpio_init, 0x0, sizeof(g_gpio_init)); /* initialize the g_gpio_init */
    g_gpio_init.mode = GPIO_MODE_INPUT;             /* input */
    g_gpio_init.flt  = GPIO_FILTER_DISABLE;         /* no filter */
    g_gpio_init.type = GPIO_TYPE_TTL;               /* ttl */
    g_gpio_init.pupd = GPIO_FLOATING;               /* no pull up and pull donw */
    g_gpio_init.func = GPIO_FUNC_4;                 /* GPIO function 4 */
    ald_gpio_init(TE_PORT, TE_PIN, &g_gpio_init);
}

/**
  * @brief  ald timer period elapsed callback
  * @param  arg: Pointer to timer_handle_t structure.
  * @retval None.
  */
void ald_timer_period_elapsed_callback(struct timer_handle_s *arg)
{
    ald_gpio_toggle_pin(TOGGLE_PORT, TOGGLE_PIN);          /* toggle io */
}

/**
  * @brief:  Initialize AD16C4T to timely overflow funtion
  * @param:  None
  * @retval: None
  */
static void init_timer(void)
{
    /* Initialize AD16C4T1 */
    memset(&g_ad16c4t_init, 0x0, sizeof(g_ad16c4t_init));
    g_ad16c4t_init.perh = AD16C4T1;
    g_ad16c4t_init.init.prescaler    = 0;
    g_ad16c4t_init.init.mode         = TIMER_CNT_MODE_UP;
    g_ad16c4t_init.init.period       = 100 - 1;
    g_ad16c4t_init.init.clk_div      = TIMER_CLOCK_DIV1;
    g_ad16c4t_init.init.re_cnt       = 0;
    g_ad16c4t_init.period_elapse_cbk = ald_timer_period_elapsed_callback;
    ald_timer_base_init(&g_ad16c4t_init);

    /* Initialize clock source */
    g_ad16c4t_clock_config.source = TIMER_SRC_ETRMODE2;     /**< TIMER clock sources */
    g_ad16c4t_clock_config.polarity = TIMER_CLK_POLARITY_RISE;  /**< TIMER clock polarity */
    g_ad16c4t_clock_config.psc = TIMER_ETR_PSC_DIV1;            /**< TIMER clock prescaler */
    g_ad16c4t_clock_config.filter = 0;                          /**< TIMER clock filter */
    ald_timer_config_clock_source(&g_ad16c4t_init, &g_ad16c4t_clock_config);

    /* Enable AD16C4T1 UPDATE interrupt */
    ald_mcu_irq_config(AD16C4T1_UP_IRQn, 0, 3, ENABLE);
    /* Start by UPDATE interrupt */
    ald_timer_base_start_by_it(&g_ad16c4t_init);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Initialize pin */
    init_gpio();

    /* Initialize timer */
    init_timer();

    while (1)
    {
        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
