/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *          20 August 2021  Lisq            NSS 引脚初始输出高电平
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */
uint8_t g_send_buf[20] = {0U};
uint8_t g_recv_buf[20] = {0U};
uint8_t g_send_len = sizeof(g_send_buf);
uint8_t g_recv_len = sizeof(g_recv_buf);
uint8_t g_send_ind = 0U;
uint8_t g_recv_ind = 0U;
/* Public Variables ---------------------------------------------------------- */

md_spi_init_t g_spi_config;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of spi module.
  * @retval None
  */
void init_spi_pin(void)
{
    md_gpio_init_t gpio_init;
    md_gpio_init_struct(&gpio_init);

    /* Initialize nss pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.podrv = MD_GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_1;
    md_gpio_init(GPIO_PORT, SPI_NSS_PIN, &gpio_init);

    /* Initialize sck pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.podrv = MD_GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_4;
    md_gpio_init(GPIO_PORT, SPI_SCK_PIN, &gpio_init);

    /* Initialize miso pin */
    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.podrv = MD_GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_4;
    md_gpio_init(GPIO_PORT, SPI_MISO_PIN, &gpio_init);

    /* Initialize mosi pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.podrv = MD_GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_4;
    md_gpio_init(GPIO_PORT, SPI_MOSI_PIN, &gpio_init);

    md_gpio_set_pin_high(GPIO_PORT, SPI_NSS_PIN);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint16_t cnt;

    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);

    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    /* enable SPI1 interrupt */
    md_mcu_irq_config(SPI1_I2S1_IRQn, 1, 1, ENABLE);

    init_spi_pin();

    md_spi_struct_init(&g_spi_config);
    g_spi_config.SPIx      = SPI1;
    g_spi_config.mode      = MD_SPI_MODE_MASTER;
    g_spi_config.dir       = MD_SPI_DIRECTION_2LINES;
    g_spi_config.data_size = MD_SPI_DATA_SIZE_8;
    g_spi_config.baud      = MD_SPI_BAUD_128;
    g_spi_config.phase     = MD_SPI_CPHA_FIRST;
    g_spi_config.polarity  = MD_SPI_CPOL_HIGH;
    g_spi_config.first_bit = MD_SPI_FIRSTBIT_MSB;
    g_spi_config.ss_en     = DISABLE;
    g_spi_config.crc_calc  = DISABLE;
    g_spi_config.crc_poly  = 0;
    md_spi_init(&g_spi_config);
    md_spi_enable_it_rxth(SPI1);

    while (1)
    {
        memcpy(g_send_buf, g_recv_buf, g_recv_len);

        md_gpio_set_pin_low(GPIO_PORT, SPI_NSS_PIN);
        /*Can send air circuit*/
        md_spi_enable_it_txe(SPI1);

        cnt = 4000;

        while (md_spi_is_enable_it_txe(SPI1) && (--cnt));

        cnt = 4000;

        while ((g_recv_ind != 0) && (--cnt));

        md_gpio_set_pin_high(GPIO_PORT, SPI_NSS_PIN);

        md_delay_1ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
