/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

uint8_t g_send_buf[20] = {0U};
uint8_t g_recv_buf[20] = {0U};
uint8_t g_send_len = sizeof(g_send_buf);
uint8_t g_recv_len = sizeof(g_recv_buf);
uint8_t g_send_ind = 0U;
uint8_t g_recv_ind = 0U;

/* Public Variables ---------------------------------------------------------- */

spi_handle_t g_h_spi;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of spi module.
  * @retval None
  */
void spi_pin_init(void)
{
    gpio_init_t x;
    memset(&x, 0x0, sizeof(gpio_init_t));

    /* Initialize nss pin */
    x.mode  = GPIO_MODE_INPUT;
    x.odos  = GPIO_PUSH_PULL;
    x.pupd  = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_1;
    x.flt   = GPIO_FILTER_DISABLE;
    x.type  = GPIO_TYPE_CMOS;
    x.func  = GPIO_FUNC_4;
    ald_gpio_init(GPIO_PORT, SPI_NSS_PIN, &x);

    /* Initialize sck pin */
    x.mode  = GPIO_MODE_INPUT;
    x.odos  = GPIO_PUSH_PULL;
    x.pupd  = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_1;
    x.flt   = GPIO_FILTER_DISABLE;
    x.type  = GPIO_TYPE_CMOS;
    x.func  = GPIO_FUNC_4;
    ald_gpio_init(GPIO_PORT, SPI_SCK_PIN, &x);

    /* Initialize miso pin */
    x.mode  = GPIO_MODE_OUTPUT;
    x.odos  = GPIO_PUSH_PULL;
    x.pupd  = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_1;
    x.flt   = GPIO_FILTER_DISABLE;
    x.type  = GPIO_TYPE_CMOS;
    x.func  = GPIO_FUNC_4;
    ald_gpio_init(GPIO_PORT, SPI_MISO_PIN, &x);

    /* Initialize mosi pin */
    x.mode  = GPIO_MODE_INPUT;
    x.odos  = GPIO_PUSH_PULL;
    x.pupd  = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_1;
    x.flt   = GPIO_FILTER_DISABLE;
    x.type  = GPIO_TYPE_CMOS;
    x.func  = GPIO_FUNC_4;
    ald_gpio_init(GPIO_PORT, SPI_MOSI_PIN, &x);

    return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_send_complete(spi_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_recv_complete(spi_handle_t *arg)
{
    return;
}
/**
  * @brief  Send and receive a message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_send_recv_complete(spi_handle_t *arg)
{
    ald_spi_send_recv_by_it(&g_h_spi, g_recv_buf, g_recv_buf, g_recv_len);
    return;
}
/**
  * @brief  Occurs error.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_error(spi_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Initialize pin */
    spi_pin_init();

    /* clear spi_handle_t structure */
    memset(&g_h_spi, 0x0, sizeof(spi_handle_t));
    /* Initialize spi */
    g_h_spi.perh           = SPI1;
    g_h_spi.init.mode      = SPI_MODE_SLAVER;
    g_h_spi.init.dir       = SPI_DIRECTION_2LINES;
    g_h_spi.init.data_size = SPI_DATA_SIZE_8;
    g_h_spi.init.baud      = SPI_BAUD_2;
    g_h_spi.init.phase     = SPI_CPHA_FIRST;
    g_h_spi.init.polarity  = SPI_CPOL_LOW;
    g_h_spi.init.first_bit = SPI_FIRSTBIT_MSB;
    g_h_spi.init.ss_en     = DISABLE;
    g_h_spi.init.crc_calc  = DISABLE;
    g_h_spi.tx_rx_cplt_cbk = spi_send_recv_complete;
    ald_spi_reset(&g_h_spi);
    ald_spi_init(&g_h_spi);

    /* Enable spi1 interrupt */
    ald_mcu_irq_config(SPI1_I2S1_IRQn, 1, 1, ENABLE);

    /* send and receive data by it */
    ald_spi_send_recv_by_it(&g_h_spi, g_recv_buf, g_recv_buf, g_recv_len);

    while (1)
    {
        ald_delay_ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
