/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include <stdio.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

static char s_flash_txbuf[32] = "essemi mcu spi flash example!";     /*Length must be less than one page (256 bytes)*/
static char s_flash_rxbuf[32];

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint32_t id;
    ald_status_t status;

    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);    /*Can make the frequency doubling, by the crystal three times the frequency of vibration to 48 MHZ*/
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);    /*Choose the frequency doubling the clock for the system clock*/
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);    /*Can make all the peripheral clock*/

    init_mcu_uart();    /*To initialize the UART module*/
    init_mcu_spi();     /*Initialize the SPI module*/

    id = flash_read_id();
    printf("\r\nManufacturer ID is %02x & Device ID is %02x %02x\r\n", (uint8_t)(id >> 16), (uint8_t)(id >> 8), (uint8_t)id);

    printf("Now erase the sector containing address 0...\r\n");
    status = flash_sector_erase(0);

    if (status == OK)
    {
        flash_wait_unbusy();    /*Waiting for erasing*/
        printf("Erase OK!\r\n");
    }

    printf("The date written to flash is -> %s\r\n", s_flash_txbuf);
    status = flash_write(0, s_flash_txbuf, strlen(s_flash_txbuf) + 1);

    if (status == OK)
    {
        flash_wait_unbusy();    /*Waiting for the written to complete*/
        printf("Write OK!\r\n");
    }

    status = flash_read(0, s_flash_rxbuf, strlen(s_flash_txbuf) + 1); /*Read write data*/
    printf("The data read from flash is  -> %s\r\n", s_flash_rxbuf);

    if (!memcmp(s_flash_txbuf, s_flash_rxbuf, strlen(s_flash_txbuf) + 1))   /*Data is written and read*/
        printf("Read OK!\r\n");
    else
        printf("Read ERROR!\r\n");

    while (1)
        ;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
