/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include <stdio.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/* Private Variables --------------------------------------------------------- */
static char s_txbuf[256] = "essemi mcu spi flash example!";     /*Length must be less than one page (256 bytes)*/
static char s_rxbuf[256];

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    uint32_t id;
    md_status_t status;

    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 24000000);       /*Choose the frequency doubling the clock for the system clock*/

    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();      /*Can make all the peripheral clock*/
    SYSCFG_LOCK();

    init_mcu_usart();    /*To initialize the USART module*/
    init_mcu_spi();     /*Initialize the SPI module*/

    id = read_flash_id();
    printf("\r\nManufacturer ID is %02x & Device ID is %02x %02x\r\n", (uint8_t)(id >> 16), (uint8_t)(id >> 8), (uint8_t)id);

    printf("Now erase the sector containing address 0...\r\n");
    status = erase_flash_sector(0);

    if (status == MD_OK)
    {
        wait_flash_unbusy();    /*Waiting for erasing*/
        printf("Erase OK!\r\n");
    }

    printf("The date written to flash is -> %s\r\n", s_txbuf);
    status = write_flash(0, s_txbuf, strlen(s_txbuf) + 1);

    if (status == MD_OK)
    {
        wait_flash_unbusy();    /*Waiting for the written to complete*/
        printf("Write OK!\r\n");
    }

    status = read_flash(0, s_rxbuf, strlen(s_txbuf) + 1);   /*Read write data*/
    printf("The data read from flash is  -> %s\r\n", s_rxbuf);

    if (!memcmp(s_txbuf, s_rxbuf, strlen(s_txbuf) + 1))   /*Data is written and read*/
    {
        printf("Read OK!\r\n");
    }
    else
    {
        printf("Read ERROR!\r\n");
    }
    
    printf("demo finished\r\n");
    
    while (1)
    {
        md_delay_1ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
