/**********************************************************************************
 *
 * @file    spi_flash.h
 * @brief   header file of spi_flash.c
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FLASH_H__
#define   __FLASH_H__
/* Includes ------------------------------------------------------------------ */
#include "md_utils.h"
#include "md_spi.h"
#include "md_gpio.h"

/* Exported Macros ----------------------------------------------------------- */
#define FLASH_WRITE_ENABLE  0x06
#define FLASH_ERASE         0x20
#define FLASH_PROGRAM       0x02
#define FLASH_READ          0x03
#define FLASH_ID            0x9F
#define FLASH_STATUS        0x05

#define SPI_SCK_PORT    GPIOB
#define SPI_SCK_PIN     MD_GPIO_PIN_10      /* PB10 */
#define SPI_NSS_PORT    GPIOB
#define SPI_NSS_PIN     MD_GPIO_PIN_12      /* PB12 */
#define SPI_MISO_PORT   GPIOC
#define SPI_MISO_PIN    MD_GPIO_PIN_5       /* PC5 */
#define SPI_MOSI_PORT   GPIOC
#define SPI_MOSI_PIN    MD_GPIO_PIN_6       /* PC6 */

#define SET_FLASH_CS()  md_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 1);
#define CLR_FLASH_CS()  md_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 0);

/* Exported Functions -------------------------------------------------------- */
void init_mcu_spi(void);
uint32_t read_flash_id(void);
md_status_t erase_flash_sector(uint32_t addr);
md_status_t write_flash(uint32_t addr, char *buf, uint8_t size);
md_status_t read_flash(uint32_t addr, char *buf, uint16_t size);
md_status_t wait_flash_unbusy(void);

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */

#endif  /* __FLASH_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
