/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"
#include "md_utils.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */
static uint8_t s_send_len = sizeof(g_send_buf);
static uint8_t s_recv_len = sizeof(g_recv_buf);
static uint8_t s_send_ind = 0U;
static uint8_t s_recv_ind = 0U;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/****************** Core Processor Exceptions HANDLER ************************/
/**
  * @brief  NMI IRQ HANDLER
  * @param  None
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ HANDLER
  * @param  None
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1);
}

/**
  * @brief  Supervisor Call IRQ HANDLER
  * @param  None
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ HANDLER
  * @param  None
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ HANDLER
  * @param  None
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ HANDLER
  * @param  None
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}

/****************** Peripheral Interrupt HANDLER ************************/
/*The SPI interrupt service function*/
void SPI1_Handler(void)
{
    if ((md_spi_is_enable_txe_interrupt(SPI1) == 1) && (md_spi_is_active_flag_txbe(SPI1) == 1))
    {

        md_spi_set_data_reg(SPI1, g_send_buf[s_send_ind++]);

        if (s_send_ind >= s_send_len)
        {
            md_spi_disable_txe_interrupt(SPI1);
            s_send_ind = 0;
            g_complete_flag = 1;
        }
    }

    if ((md_spi_is_enable_rxne_interrupt(SPI1) == 1) && (md_spi_is_active_flag_rxbne(SPI1) == 1))
    {

        g_recv_buf[s_recv_ind++] = md_spi_get_data_reg_value(SPI1);

        if (s_recv_ind >= s_recv_len)
        {
            s_recv_ind = 0;
        }
    }
}

/**
  * @} Examples_SPI
  */

/**
  * @} Projects_Examples_ALD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
