/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

/* SPI0 IO pin definition */
#define SPI_SCK_PORT    GPIOB
#define SPI_SCK_PIN     MD_GPIO_PIN_10      /* PB10 */
#define SPI_NSS_PORT    GPIOB
#define SPI_NSS_PIN     MD_GPIO_PIN_12      /* PB12 */
#define SPI_MISO_PORT   GPIOC
#define SPI_MISO_PIN    MD_GPIO_PIN_5       /* PC5 */
#define SPI_MOSI_PORT   GPIOC
#define SPI_MOSI_PIN    MD_GPIO_PIN_6       /* PC6 */

/* Exported Variables -------------------------------------------------------- */
extern uint8_t g_send_buf[20];
extern uint8_t g_recv_buf[20];
extern volatile uint8_t g_complete_flag;

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

#endif    /*__MAIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
