/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"
#include <string.h>

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */ 
uint8_t g_send_buf[20] = {0x00};
uint8_t g_recv_buf[20] = {0x00};

/* Public Variables ---------------------------------------------------------- */
spi_handle_t g_spi_handle;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */

/*The host communication pins initialization function*/
void init_spi_pin(void)
{
    gpio_init_t gpio_config;

    /*SCK pin initialization, configuration for the output mode*/
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_6;
    ald_gpio_init(SPI_SCK_PORT, SPI_SCK_PIN, &gpio_config);

    /*MISO pins initialization, configuration for the input mode*/
    gpio_config.mode = GPIO_MODE_INPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_6;
    ald_gpio_init(SPI_MISO_PORT, SPI_MISO_PIN, &gpio_config);

    /*Initialization, MOSI pin is configured to output mode*/
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_6;
    ald_gpio_init(SPI_MOSI_PORT, SPI_MOSI_PIN, &gpio_config);

    /*CS choose pin initialization, configuration for the output mode*/
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.func = GPIO_FUNC_1;
    ald_gpio_init(SPI_NSS_PORT, SPI_NSS_PIN, &gpio_config);
    ald_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 1);

    return;
}

/*Completion of SPI*/
void spi_send_complete(spi_handle_t *arg)
{
    return;
}

/*SPI receive complete*/
void spi_recv_complete(spi_handle_t *arg)
{
    return;
}

/*SPI transceiver to complete*/
void spi_send_recv_complete(spi_handle_t *arg)
{
    return;
}

/*SPI transceiver error*/
void spi_error(spi_handle_t *arg)
{
    return;
}

/*The main function*/
int main(void)
{
    /*Initialize the ALD*/
    ald_cmu_init();
    ald_cmu_clock_config(CMU_CLOCK_HRC, 24000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /*Initialize the host communication pin*/
    init_spi_pin();

    /*Interrupt priority level and make configuration can interrupt*/
    ald_mcu_irq_config(SPI1_IRQn, 1, ENABLE);

    /*Empty the SPI initialization structure*/
    memset(&g_spi_handle, 0, sizeof(g_spi_handle));
    /*User configuration SPI module*/
    g_spi_handle.perh           = SPI1;
    g_spi_handle.init.mode      = SPI_MODE_MASTER;             /*Host mode*/
    g_spi_handle.init.dir       = SPI_DIRECTION_2LINES;        /*Full duplex*/
    g_spi_handle.init.data_size = SPI_DATA_SIZE_8;
    g_spi_handle.init.baud      = SPI_BAUD_64;
    g_spi_handle.init.phase     = SPI_CPHA_SECOND;             /*The second clock edge sampling data*/
    g_spi_handle.init.polarity  = SPI_CPOL_HIGH;               /*High level of free clock*/
    g_spi_handle.init.first_bit = SPI_FIRSTBIT_MSB;            /*High in the former*/
    g_spi_handle.init.ss_en     = DISABLE;
    g_spi_handle.init.crc_calc  = DISABLE;
    g_spi_handle.init.crc_poly  = 0;
    g_spi_handle.tx_cplt_cbk    = spi_send_complete;
    g_spi_handle.rx_cplt_cbk    = spi_recv_complete;
    g_spi_handle.tx_rx_cplt_cbk = spi_send_recv_complete;
    g_spi_handle.err_cbk        = spi_error;
    ald_spi_reset(&g_spi_handle);
    ald_spi_init(&g_spi_handle);

    while (1)
    {
        memcpy(g_send_buf, g_recv_buf, sizeof(g_send_buf));
        
        /*Lower NSS pin to select the external from the machine*/
        ald_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 0);
        /*The host interrupt receiving*/
        ald_spi_send_recv_by_it(&g_spi_handle, g_send_buf, g_recv_buf, sizeof(g_recv_buf));
        /*Raise the NSS pin to release the external from the machine*/
        ald_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 1);
        ald_delay_ms(2000);
    }
}

/**
  * @} Examples_SPI
  */

/**
  * @} Projects_Examples_ALD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
