/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"
#include "utils.h"
#include "ald_cmu.h"
#include "ald_uart.h"
#ifdef ALD_DMA
    #include "ald_dma.h"
#endif     /*ALD_DMA*/

#include "shell.h"

/* Private Macros ------------------------------------------------------------ */

#define UART_BUF_LEN 128

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    ald_inc_tick();
    return;
}

/**
  * @brief  CMU IRQ#6 handler
  * @retval None
  */
void CMU_Handler(void)
{
    ald_cmu_irq_handler();
    return;
}

#ifdef ALD_DMA
/**
  * @brief  DMA IRQ#66 handler
  * @retval None
  */
void DMA_Handler(void)
{
    ald_dma_irq_handler();
}
#endif   /*ALD_DMA*/

/**
  * @brief  RTC IRQ handler
  * @retval None
  */
void RTC_Handler(void)
{
    /* Handle rtc interrupt */
    rtc_irq_handler();
    return;
}

/**
  * @brief  UART IRQ handler
  * @retval None
  */
void UART1_Handler(void)
{
    static char gUartBuf[UART_BUF_LEN];
    static int Idx = 0;
    static uint8_t EscFlag = 0;
    static char EscBuf[4];
    char Resieve;
    uint16_t cnt;

    if (ald_uart_get_mask_flag_status(&g_h_uart, UART_IF_RFTH) != RESET)
    {
        ald_uart_clear_flag_status(&g_h_uart, UART_IF_RFTH);

        Resieve = g_h_uart.perh->RXBUF;

        if (EscFlag)
        {
            EscBuf[EscFlag - 1] = Resieve;

            if (EscFlag == 2)
            {
                EscBuf[2] = 0;

                cnt = 4000;

                while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

                g_h_uart.perh->TXBUF = '\n';

                cnt = 4000;

                while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

                g_h_uart.perh->TXBUF = '\r';

                Q_Sh_CmdHandler(1, EscBuf);
                EscFlag = 0;
            }
            else
            {
                EscFlag++;
            }
        }
        else
        {
            if (Resieve == 13)
            {
                gUartBuf[Idx] = 0;

                cnt = 4000;

                while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

                g_h_uart.perh->TXBUF = '\n';

                cnt = 4000;

                while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

                g_h_uart.perh->TXBUF = '\r';

                if (Idx == 0)
                    printf("Shell>>");
                else
                    Q_Sh_CmdHandler(0, gUartBuf);

                Idx = 0;
            }
            else if (Resieve == 0x09)
            {
                gUartBuf[4] = 0;

                cnt = 4000;

                while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

                g_h_uart.perh->TXBUF = '\n';

                cnt = 4000;

                while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

                g_h_uart.perh->TXBUF = '\r';

                gUartBuf[0] = 'l';
                gUartBuf[1] = 'f';
                gUartBuf[2] = '(';
                gUartBuf[3] = ')';
                Q_Sh_CmdHandler(0, gUartBuf);
                Idx = 0;
            }
            else if (Resieve == 0x08)
            {
                if (Idx > 0)
                {
                    gUartBuf[--Idx] = 0;

                    cnt = 4000;

                    while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

                    g_h_uart.perh->TXBUF = '\b';

                    cnt = 4000;

                    while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

                    g_h_uart.perh->TXBUF = ' ';

                    cnt = 4000;

                    while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

                    g_h_uart.perh->TXBUF = '\b';
                }
            }
            else if (Resieve >= 0x20)
            {
                gUartBuf[Idx++] = Resieve;

                cnt = 4000;

                while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

                g_h_uart.perh->TXBUF = Resieve;

            }
            else if (Resieve == 0x1B)
            {
                EscFlag = 1;
            }
            else
            {
            }

            if (Idx >= UART_BUF_LEN)
                Idx--;
        }
    }

    return;
}

#pragma import(__use_no_semihosting)
struct __FILE
{
    int handle;
};
FILE __stdout;

void _sys_exit(int x)
{
    x = x;
}

#ifdef __GNUC__     /* GCC Compiler */
int _write(int file, const void *ptr, int len)
{
    uint16_t cnt;
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        if (*ptr_char == '\n')
        {
            cnt = 4000;

            while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

            g_h_uart.perh->TXBUF = '\r';
        }

        cnt = 4000;

        while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt));

        g_h_uart.perh->TXBUF = *ptr_char++;
    }

    return len;
}

void *_sbrk(intptr_t increment)
{
    extern char end asm("end");
    /* Defined by the linker. */
    static char *heap_end;
    char *prev_heap_end;

    heap_end += increment;

    return (void *)prev_heap_end;
}

void _read()
{

}

void _lseek()
{

}

void _close()
{

}

void _fstat()
{

}

void _isatty()
{

}

void _getpid()
{

}

void _kill()
{

}

void _exit()
{

}

#else
int fputc(int c, FILE *f)
{
    uint16_t cnt = 4000U;

    while (!ald_uart_get_status(&g_h_uart, UART_STATUS_TFEMPTY) && (--cnt))
    {

    }

    g_h_uart.perh->TXBUF = c;

    return c;
}

#endif /* __GNUC__ */
/**
  * @}
  */
/**
  * @}
  */


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
