/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

void rtco_pin_init(void)
{
    gpio_init_t x;
    memset(&x, 0x00, sizeof(gpio_init_t));

    /* Initialize RTCO #0 pin */
    x.mode  = GPIO_MODE_OUTPUT;
    x.odos  = GPIO_PUSH_PULL;
    x.flt   = GPIO_FILTER_DISABLE;
    x.type  = GPIO_TYPE_CMOS;
    x.nodrv = GPIO_OUT_DRIVE_6;
    x.podrv = GPIO_OUT_DRIVE_6;
    x.func  = GPIO_FUNC_6;

    ald_gpio_init(RTC_CLKOUTPUT_PORT, RTC_CLKOUTPUT_PIN, &x);
}

/**
  * @brief  Test RTC time and date functions
  * @retval Status.
  */
int main(void)
{
    rtc_init_t rtc_init;

    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
    /* Set RTC clock */
    ald_rtc_source_select(RTC_SOURCE_LOSC);

    rtco_pin_init();
    /* Enable RTC interrupt */
    ald_mcu_irq_config(RTC_IRQn, 0, 3, ENABLE);

    memset(&rtc_init, 0x00, sizeof(rtc_init_t));
    /* Initialize RTC */
    rtc_init.asynch_pre_div  = 0;
    rtc_init.synch_pre_div   = 32767;
    rtc_init.hour_format     = RTC_HOUR_FORMAT_24;
    rtc_init.output          = RTC_OUTPUT_DISABLE;
    rtc_init.output_polarity = RTC_OUTPUT_POLARITY_HIGH;
    ald_rtc_init(&rtc_init);

    ald_rtc_set_clock_output(RTC_CLOCK_OUTPUT_EXA_1);

    while (1);
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
