/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

rtc_time_t g_time;
rtc_date_t g_date;
rtc_alarm_t g_alarm;

uint8_t g_alarm_occur = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Test RTC time and date functions
  * @retval Status.
  */
int main(void)
{
    rtc_init_t rtc_init;

    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
    ald_rtc_source_select(RTC_SOURCE_LOSC);
    /* Enable RTC interrupt */
    ald_mcu_irq_config(RTC_IRQn, 0, 3, ENABLE);

    memset(&rtc_init, 0x00, sizeof(rtc_init_t));
    /* Initialize RTC */
    rtc_init.asynch_pre_div  = 0;
    rtc_init.synch_pre_div   = 32767;
    rtc_init.hour_format     = RTC_HOUR_FORMAT_24;
    rtc_init.output          = RTC_OUTPUT_DISABLE;
    rtc_init.output_polarity = RTC_OUTPUT_POLARITY_HIGH;
    ald_rtc_init(&rtc_init);

    /* Set current time and date */
    memset(&g_time, 0x00, sizeof(rtc_time_t));
    g_time.hour    = 9;
    g_time.minute  = 30;
    g_time.second  = 0;
    memset(&g_date, 0x00, sizeof(rtc_date_t));
    g_date.day     = 23;
    g_date.month   = 7;
    g_date.year    = 20;
    g_date.week    = 4;
    ald_rtc_set_time(&g_time, RTC_FORMAT_DEC);
    ald_rtc_set_date(&g_date, RTC_FORMAT_DEC);

    /* Set alarm */
    memset(&g_alarm, 0x00, sizeof(rtc_alarm_t));
    g_alarm.idx          = RTC_ALARM_A;
    g_alarm.mask         = RTC_ALARM_MASK_NONE;
    g_alarm.sel          = RTC_SELECT_DAY;
    g_alarm.ss_mask      = RTC_ALARM_SS_MASK_ALL;
    g_alarm.time.hour    = 9;
    g_alarm.time.minute  = 30;
    g_alarm.time.second  = 20;
    g_alarm.day          = 23;
    ald_rtc_set_alarm(&g_alarm, RTC_FORMAT_DEC);

    /* Enable alarm-a interrupt */
    ald_rtc_interrupt_config(RTC_IT_ALMA, ENABLE);

    while (1)
    {
        ald_rtc_get_time(&g_time, RTC_FORMAT_DEC);
        ald_rtc_get_date(&g_date, RTC_FORMAT_DEC);
        ald_delay_ms(1000);
    }
}


/**
  * @brief  RTC IRQ handler
  * @retval None
  */
void rtc_irq_handler(void)
{
    if (ald_rtc_get_flag_status(RTC_IF_ALMA) == SET)
    {
        ald_rtc_clear_flag_status(RTC_IF_ALMA);
        g_alarm_occur = 1;
    }
}


/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
