/**********************************************************************************
 *
 * @file    uart.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    zhuxf          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include <stdio.h>
#include "uart.h"


/* Private Macros ----------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */

static uart_handle_t s_uart_handle;

/* Public Variables -------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

static void uart_pin_init(void);

/* Private Function---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  uart function
  * @retval None.
  */
void mcu_uart_init(void)
{
    uart_pin_init();

    s_uart_handle.perh             = UART0;
    s_uart_handle.init.mode        = UART_MODE_UART;
    s_uart_handle.init.baud        = 115200;       /*115200 8 1 N*/
    s_uart_handle.init.word_length = UART_WORD_LENGTH_8B;
    s_uart_handle.init.stop_bits   = UART_STOP_BITS_1;
    s_uart_handle.init.parity      = UART_PARITY_NONE;
    s_uart_handle.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&s_uart_handle);         /*初始化并使能UART0*/
}

/**
  * @brief  uart pin function
  * @retval None.
  */
static void uart_pin_init(void)
{
    gpio_init_t gpio_config;

    gpio_config.func = GPIO_FUNC_3;
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.type = GPIO_TYPE_TTL;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    ald_gpio_init(GPIOB, GPIO_PIN_10, &gpio_config);     /*初始化UART0 TX管脚*/

    gpio_config.mode = GPIO_MODE_INPUT;
    ald_gpio_init(GPIOB, GPIO_PIN_11, &gpio_config);     /*除管脚方向为输入外其它配置与UART0 TX管脚相同*/
}

int fputc(int c, FILE *f)   /*重定向printf输出至串口*/
{
    while ((ald_uart_get_status(&s_uart_handle, UART_STATUS_TFTH)) != SET) ;   /*等待上一字节发送完成*/

    s_uart_handle.perh->TXBUF = (uint8_t)c;    /*UART发送*/

    return c;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
