/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    zhuxf          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include <stdio.h>
#include "main.h"


/* Private Macros ----------------------------------------------------------- */

#define BUFFER_SIZE 32

/* Private Variables--------------------------------------------------------- */

/* Public Variables -------------------------------------------------------- */

qspi_dac_cfg_t g_dac;
qspi_handle_t  g_hqspi;

uint32_t g_wdata[BUFFER_SIZE];
uint32_t g_rdata[BUFFER_SIZE];

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    uint32_t i = 0U;

    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);    /*使能倍频，由晶振三分频倍频至48MHz*/
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);    /*选择倍频时钟为系统时钟*/
    ald_cmu_qspi_clock_select(CMU_QSPI_CLOCK_SEL_HCLK2);    /*选择HCLK2为QSPI时钟*/
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);    /*使能所有外设时钟*/

    ald_cmu_init();

    for (i = 0; i < BUFFER_SIZE; i++)
    {
        g_wdata[i] = 0x11223300 + i;
        g_rdata[i] = 0;
    }

    qspi_pin_init();

    bsp_qspi_indac_init(&g_hqspi);

    bsp_w25q128_reset(&g_hqspi);
    bsp_w25q128_erase_block(&g_hqspi, 0);

    if (bsp_qspi_indac_poll_transmit(&g_hqspi, 0x00000000, (uint8_t *)g_wdata, 32 * 4) != OK)
    {
        while (1);
    }

    ald_delay_ms(1000);

    if (bsp_qspi_indac_poll_receive(&g_hqspi, 0x00000000, (uint8_t *)g_rdata, 32 * 4) != OK)
    {
        while (1);
    }

    ald_delay_ms(1000);

    while (1)
    {

    }
}

/**
  * @brief  Initializate spi flash pin
  * @retval None.
  */
static void qspi_pin_init(void)
{
    gpio_init_t gpio_config;

    gpio_config.odos  = GPIO_PUSH_PULL;
    gpio_config.pupd  = GPIO_PUSH_UP;
    gpio_config.nodrv = GPIO_OUT_DRIVE_6;
    gpio_config.podrv = GPIO_OUT_DRIVE_6;
    gpio_config.flt   = GPIO_FILTER_DISABLE;
    gpio_config.type  = GPIO_TYPE_TTL;

    gpio_config.func  = GPIO_FUNC_6;
    gpio_config.mode  = GPIO_MODE_OUTPUT;
    ald_gpio_init(GPIOB, GPIO_PIN_12, &gpio_config); /*初始化PB12为片选管脚*/
    ald_gpio_init(GPIOB, GPIO_PIN_13, &gpio_config); /*初始化PB13为时钟输出管脚*/

    gpio_config.func  = GPIO_FUNC_6;
    gpio_config.mode = GPIO_MODE_INPUT;
    ald_gpio_init(GPIOB, GPIO_PIN_14, &gpio_config); /*初始化PB14为IO0管脚*/
    ald_gpio_init(GPIOB, GPIO_PIN_15, &gpio_config); /*初始化PB15为IO1管脚*/
    ald_gpio_init(GPIOB, GPIO_PIN_10, &gpio_config); /*初始化PB10为IO2管脚*/
    ald_gpio_init(GPIOB, GPIO_PIN_11, &gpio_config); /*初始化PB11为IO3管脚*/
    
    return;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
