/**********************************************************************************
 *
 * @file    led.c
 * @brief   led file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    zhuxf          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include "led.h"


/* Private Macros ----------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */

/* Public Variables --------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief Led function
  * @param None
  * @retval None
  */
void led_init(void)
{
    gpio_init_t gpio_config;

    gpio_config.func  = GPIO_FUNC_1;
    gpio_config.mode  = GPIO_MODE_OUTPUT;
    gpio_config.odos  = GPIO_PUSH_PULL;
    gpio_config.pupd  = GPIO_PUSH_UP;
    gpio_config.nodrv = GPIO_OUT_DRIVE_6;
    gpio_config.podrv = GPIO_OUT_DRIVE_6;
    gpio_config.flt   = GPIO_FILTER_DISABLE;
    gpio_config.type  = GPIO_TYPE_TTL;

    ald_gpio_init(GPIOC, GPIO_PIN_6, &gpio_config); /*初始化PC6为片选管脚*/
    ald_gpio_init(GPIOC, GPIO_PIN_12, &gpio_config); /*初始化PC12为时钟输出管脚*/

    ald_gpio_write_pin(GPIOC, GPIO_PIN_6, 0);   /*IO初始输出状态*/
    ald_gpio_write_pin(GPIOC, GPIO_PIN_12, 1);
}

/**
  * @brief Led toggle function
  * @param None
  * @retval None
  */
void led_toggle(void)
{
    ald_gpio_toggle_pin(GPIOC, GPIO_PIN_6); /*翻转IO*/
    ald_gpio_toggle_pin(GPIOC, GPIO_PIN_12);
}

/**
* @}
*/
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
