/**********************************************************************************
 *
 * @file    qspi_flash.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    zhuxf          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FLASH_H__
#define   __FLASH_H__

/* Includes ---------------------------------------------------------------- */

#include "utils.h"
#include "ald_qspi.h"
#include "ald_gpio.h"


/* Exported Macros ----------------------------------------------------------- */

/* Exported Types ---------------------------------------------------------- */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */

ald_status_t bsp_w25q128_reset(qspi_handle_t *hqspi);
ald_status_t bsp_w25q128_wr_enable(qspi_handle_t *hqspi);
ald_status_t bsp_w25q128_erase_block(qspi_handle_t *hqspi, uint32_t blkaddr);
ald_status_t bsp_w25q128_enable_quad_mode(qspi_handle_t *hqspi);
ald_status_t bsp_w25q128_disable_protect(qspi_handle_t *hqspi);

#endif /* __FLASH_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
