/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Only one macro can be opened at a time */
/* #define LP_MODE_STOP1 */
#define LP_MODE_STOP2
/* #define LP_MODE_STANDBY */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initializate pin of led module.
  * @retval None
  */
void init_led_pin(void)
{
    md_gpio_init_t gpio_init;

    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.podrv = MD_GPIO_OUT_DRIVE_6;
    gpio_init.nodrv = MD_GPIO_OUT_DRIVE_6;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_1;

    md_gpio_init(LED_PORT, LED_PIN, &gpio_init);
    md_gpio_write_pin(LED_PORT, LED_PIN, 1);

    return;
}

/**
  * @brief  Initializate lvd.
  * @retval None
  */
void init_lvd_powerdown(void)
{
    SYSCFG_UNLOCK();
    md_pmu_lvd_config(MD_PMU_LVD_VOL_SEL_3_4, MD_PMU_LVD_TRIGGER_HIGH_LEVEL, ENABLE);
    md_pmu_set_lvd_it_flag(); /* clear LVD interrupt flag */
    SYSCFG_LOCK();
    NVIC_ClearPendingIRQ(LVD_IRQn);

    return;
}
/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HRC_6, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    init_lvd_powerdown();
    md_delay_1ms(10);

    if (md_pmu_is_active_flag_lvd_it())    /* power is lower */
    {
        bat_proc();
    }

    init_led_pin();
    init_lvd_powerdown();
    md_mcu_irq_config(LVD_IRQn, 0, 0, ENABLE);

    while (1)
    {
        md_gpio_write_pin(LED_PORT, LED_PIN, 0);
        md_delay_1ms(500);
        md_gpio_write_pin(LED_PORT, LED_PIN, 1);
        md_delay_1ms(500);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
