/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_PMU
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Only one macro can be opened at a time */
/* #define LP_MODE_STOP1 */
#define LP_MODE_STOP2
/* #define LP_MODE_STANDBY */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of led module.
  * @retval None
  */
void init_led_pin(void)
{
    gpio_init_t gpio_init;

    memset(&gpio_init, 0x0, sizeof(gpio_init)); /* initialize the gpio_init */
    gpio_init.mode = GPIO_MODE_OUTPUT;
    gpio_init.odos = GPIO_PUSH_PULL;
    gpio_init.pupd = GPIO_PUSH_UP;
    gpio_init.podrv = GPIO_OUT_DRIVE_6;
    gpio_init.nodrv = GPIO_OUT_DRIVE_6;
    gpio_init.flt  = GPIO_FILTER_DISABLE;
    gpio_init.type = GPIO_TYPE_CMOS;
    gpio_init.func = GPIO_FUNC_1;

    ald_gpio_init(LED_PORT, LED_PIN, &gpio_init);
    ald_gpio_write_pin(LED_PORT, LED_PIN, 1);

    return;
}

/**
  * @brief  Initializate lvd.
  * @retval None
  */
void init_lvd_powerdown(void)
{
    SYSCFG_UNLOCK();
    ald_pmu_lvd_config(PMU_LVD_VOL_SEL_3_2, PMU_LVD_TRIGGER_HIGH_LEVEL, ENABLE);
    SET_BIT(PMU->LVDCR, PMU_LVDCR_LVDCIF_MSK);
    SYSCFG_LOCK();
    NVIC_ClearPendingIRQ(LVD_IRQn);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    init_lvd_powerdown();
    ald_delay_ms(10);

    if (READ_BITS(PMU->LVDCR, PMU_LVDCR_LVDIF_MSK, PMU_LVDCR_LVDIF_POS) == 1U)    /* power is lower */
    {
        bat_proc();
    }

    init_led_pin();
    init_lvd_powerdown();
    ald_mcu_irq_config(LVD_IRQn, 0, 0, ENABLE);

    while (1)
    {
        ald_gpio_write_pin(LED_PORT, LED_PIN, 0);
        ald_delay_ms(500);
        ald_gpio_write_pin(LED_PORT, LED_PIN, 1);
        ald_delay_ms(500);
    }
}

/**
  * @brief  GPIO IRQ handler
  * @retval None
  */
__isr__ void gpio_irq_handler(void)
{
    /* Check and clear interrupt flag */
    ald_gpio_exti_get_flag_status(PMU_EXTI_PIN);
    ald_gpio_exti_clear_flag_status(PMU_EXTI_PIN);

    return;
}

/**
  * @brief  LVD IRQ processing task
  * @retval None
  */
void lvd_irq_proc(void)
{
    NVIC_SystemReset();
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
