/**********************************************************************************
 *
 * @file    iap_rom.h
 * @brief   iap function interface in iap rom
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef _IAP_ROM_H_
#define _IAP_ROM_H_

/* Includes ------------------------------------------------------------------ */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

/* Public types ------------------------------------------------------------ */

/* Exported Types ------------------------------------------------------------ */

/**
  *@brief config the multi-words write function support automatic erasing
  */
typedef enum
{
    AUTO_ERASE_FALSE = 0x0U,
    AUTO_ERASE_TRUE  = 0x1U,
} type_auto_erase_t;

/**
  *@brief funtion pointer type for page erase
  */
typedef uint32_t (*iaprom_page_erase_t)(uint32_t);

/**
  *@brief funtion pointer type for simple word write
  */
typedef uint32_t (*iaprom_word_progrm_t)(uint32_t, uint32_t);

/**
  *@brief funtion pointer type for double words write
  */
typedef uint32_t (*iaprom_words_progrm_t)(uint32_t, uint32_t, uint32_t);

/**
  *@brief funtion pointer type for multiple words write
  */
typedef uint32_t (*iaprom_multi_progrm_t)(uint32_t, uint32_t, uint32_t, type_auto_erase_t);

/* Public macros ------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

#define  IAPROM_PAGE_ERASE  ((iaprom_page_erase_t)(*((uint32_t *)0x10000004)))

#define  IAPROM_WORD_PROGRAM  ((iaprom_word_progrm_t)(*((uint32_t *)0x10000008)))

#define  IAPROM_WORDS_PROGRAM  ((iaprom_words_progrm_t)(*((uint32_t *)0x1000000C)))

#define  IAPROM_MULTI_PROGRAM  ((iaprom_multi_progrm_t)(*((uint32_t *)0x10000000)))

#endif /* _IAP_ROM_H_ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
