/**********************************************************************************
 *
 * @file    ram_vectors.c
 * @brief   ram_vectors C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */
#include "ram_vectors.h"
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

__weak void NMI_Handler_RAM(void)
{
    while (1);
}
__weak void HardFault_Handler_RAM(void)
{
    while (1);
}
__weak void MemManage_Handler_RAM(void)
{
    while (1);
}
__weak void BusFault_Handler_RAM(void)
{
    while (1);
}
__weak void UsageFault_Handler_RAM(void)
{
    while (1);
}
__weak void SVC_Handler_RAM(void)
{
    while (1);
}
__weak void DebugMon_Handler_RAM(void)
{
    while (1);
}
__weak void PendSV_Handler_RAM(void)
{
    while (1);
}
__weak void SysTick_Handler_RAM(void)
{
    __NOP();
}
__weak void WWDG_Handler_RAM(void)
{
    while (1);
}
__weak void IWDG_Handler_RAM(void)
{
    while (1);
}
__weak void LVD_Handler_RAM(void)
{
    while (1);
}
__weak void RTC_Handler_RAM(void)
{
    while (1);
}
__weak void CMU_Handler_RAM(void)
{
    while (1);
}
__weak void ADC0_Handler_RAM(void)
{
    while (1);
}
__weak void CAN0_TX_Handler_RAM(void)
{
    while (1);
}
__weak void CAN0_RX0_Handler_RAM(void)
{
    while (1);
}
__weak void CAN0_RX1_Handler_RAM(void)
{
    while (1);
}
__weak void CAN0_EXCEPTION_Handler_RAM(void)
{
    while (1);
}
__weak void AD16C4T0_BRK_Handler_RAM(void)
{
    while (1);
}
__weak void AD16C4T0_UP_Handler_RAM(void)
{
    while (1);
}
__weak void AD16C4T0_TRIG_COM_Handler_RAM(void)
{
    while (1);
}
__weak void AD16C4T0_CC_Handler_RAM(void)
{
    while (1);
}
__weak void AD16C4T1_BRK_Handler_RAM(void)
{
    while (1);
}
__weak void AD16C4T1_UP_Handler_RAM(void)
{
    while (1);
}
__weak void AD16C4T1_TRIG_COM_Handler_RAM(void)
{
    while (1);
}
__weak void AD16C4T1_CC_Handler_RAM(void)
{
    while (1);
}
__weak void GP32C4T0_Handler_RAM(void)
{
    while (1);
}
__weak void GP32C4T1_Handler_RAM(void)
{
    while (1);
}
__weak void BS16T0_Handler_RAM(void)
{
    while (1);
}
__weak void BS16T1_Handler_RAM(void)
{
    while (1);
}
__weak void GP16C4T0_Handler_RAM(void)
{
    while (1);
}
__weak void GP16C4T1_Handler_RAM(void)
{
    while (1);
}
__weak void DAC0_CH0_Handler_RAM(void)
{
    while (1);
}
__weak void I2C0_EV_Handler_RAM(void)
{
    while (1);
}
__weak void I2C0_ERR_Handler_RAM(void)
{
    while (1);
}
__weak void I2C1_EV_Handler_RAM(void)
{
    while (1);
}
__weak void I2C1_ERR_Handler_RAM(void)
{
    while (1);
}
__weak void SPI0_I2S0_Handler_RAM(void)
{
    while (1);
}
__weak void SPI1_I2S1_Handler_RAM(void)
{
    while (1);
}
__weak void UART0_Handler_RAM(void)
{
    while (1);
}
__weak void UART1_Handler_RAM(void)
{
    while (1);
}
__weak void UART2_Handler_RAM(void)
{
    while (1);
}
__weak void UART3_Handler_RAM(void)
{
    while (1);
}
__weak void UART4_Handler_RAM(void)
{
    while (1);
}
__weak void UART5_Handler_RAM(void)
{
    while (1);
}
__weak void CRYPT_Handler_RAM(void)
{
    while (1);
}
__weak void ACMP0_Handler_RAM(void)
{
    while (1);
}
__weak void ACMP1_Handler_RAM(void)
{
    while (1);
}
__weak void SPI2_I2S2_Handler_RAM(void)
{
    while (1);
}
__weak void EBI_Handler_RAM(void)
{
    while (1);
}
__weak void TRNG_Handler_RAM(void)
{
    while (1);
}
__weak void TSENSE_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI0_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI1_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI2_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI3_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI4_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI5_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI6_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI7_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI8_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI9_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI10_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI11_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI12_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI13_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI14_Handler_RAM(void)
{
    while (1);
}
__weak void EXTI15_Handler_RAM(void)
{
    while (1);
}
__weak void DMA_Handler_RAM(void)
{
    while (1);
}
__weak void ADC1_Handler_RAM(void)
{
    while (1);
}
__weak void DAC0_CH1_Handler_RAM(void)
{
    while (1);
}
__weak void QSPI_Handler_RAM(void)
{
    while (1);
}
__weak void USB_INT_Handler_RAM(void)
{
    while (1);
}
__weak void USB_DMA_Handler_RAM(void)
{
    while (1);
}
__weak void ACMP2_Handler_RAM(void)
{
    while (1);
}

/* Private Constants --------------------------------------------------------- */

/* Public Constants ---------------------------------------------- */
volatile const vect_t g_vectors_list_ram[] __attribute__((aligned(256))) =
{
    (vect_t)0,                               /* 0,  load top of stack                  */
    (vect_t)0,                               /* 1,  reset handler                      */
    (vect_t)NMI_Handler_RAM,                 /* 2,  nmi handler                        */
    (vect_t)HardFault_Handler_RAM,           /* 3,  hard fault handler                 */
    (vect_t)MemManage_Handler_RAM,           /* 4,  MPU Fault Handler                  */
    (vect_t)BusFault_Handler_RAM,            /* 5,  Bus Fault Handler                  */
    (vect_t)UsageFault_Handler_RAM,          /* 6,  Usage Fault Handler                */
    (vect_t)0,                               /* 7,  Reserved                           */
    (vect_t)0,                               /* 8,  Reserved                           */
    (vect_t)0,                               /* 9,  Reserved                           */
    (vect_t)0,                               /* 10, Reserved                           */
    (vect_t)SVC_Handler_RAM,                 /* 11, svcall handler                     */
    (vect_t)DebugMon_Handler_RAM,            /* 12, Debug Monitor Handler              */
    (vect_t)0,                               /* 13, Reserved                           */
    (vect_t)PendSV_Handler_RAM,              /* 14, pendsv handler                     */
    (vect_t)SysTick_Handler_RAM,             /* 15, systick handler                    */
    (vect_t)WWDG_Handler_RAM,                /* 16, irq0    WWDG handler               */
    (vect_t)IWDG_Handler_RAM,                /* 17, irq1    IWDG handler               */
    (vect_t)LVD_Handler_RAM,                 /* 18, irq2    LVD handler                */
    (vect_t)RTC_Handler_RAM,                 /* 19, irq3    RTC handler                */
    (vect_t)0,                               /* 20, irq4    Reserved                   */
    (vect_t)0,                               /* 21, irq5    Reserved                   */
    (vect_t)CMU_Handler_RAM,                 /* 22, irq6    CMU handler                */
    (vect_t)ADC0_Handler_RAM,                /* 23, irq7    ADC0 handler               */
    (vect_t)CAN0_TX_Handler_RAM,             /* 24, irq8    CAN0_TX handler            */
    (vect_t)CAN0_RX0_Handler_RAM,            /* 25, irq9    CAN0_RX0 handler           */
    (vect_t)CAN0_RX1_Handler_RAM,            /* 26, irq10   CAN0_RX1 handler           */
    (vect_t)CAN0_EXCEPTION_Handler_RAM,      /* 27, irq11   CAN0_EXCEPTION handler     */
    (vect_t)AD16C4T0_BRK_Handler_RAM,        /* 28, irq12   AD16C4T0_BRK handler       */
    (vect_t)AD16C4T0_UP_Handler_RAM,         /* 29, irq13   AD16C4T0_UP handler        */
    (vect_t)AD16C4T0_TRIG_COM_Handler_RAM,   /* 30, irq14   AD16C4T0_TRIG_COM handler  */
    (vect_t)AD16C4T0_CC_Handler_RAM,         /* 31, irq15   AD16C4T0_CC handler        */
    (vect_t)AD16C4T1_BRK_Handler_RAM,        /* 32, irq16   AD16C4T1_BRK handler       */
    (vect_t)AD16C4T1_UP_Handler_RAM,         /* 33, irq17   AD16C4T1_UP handler        */
    (vect_t)AD16C4T1_TRIG_COM_Handler_RAM,   /* 34, irq18   AD16C4T1_TRIG_COM handler  */
    (vect_t)AD16C4T1_CC_Handler_RAM,         /* 35, irq19   AD16C4T1_CC handler        */
    (vect_t)GP32C4T0_Handler_RAM,            /* 36, irq20   GP32C4T0 handler           */
    (vect_t)GP32C4T1_Handler_RAM,            /* 37, irq21   GP32C4T1 handler           */
    (vect_t)BS16T0_Handler_RAM,              /* 38, irq22   BS16T0 handler             */
    (vect_t)BS16T1_Handler_RAM,              /* 39, irq23   BS16T1 handler             */
    (vect_t)GP16C4T0_Handler_RAM,            /* 40, irq24   GP16C4T0 handler           */
    (vect_t)GP16C4T1_Handler_RAM,            /* 41, irq25   GP16C4T1 handler           */
    (vect_t)0,                               /* 42, irq26   Reserved                   */
    (vect_t)DAC0_CH0_Handler_RAM,            /* 43, irq27   DAC0_CH0 handler           */
    (vect_t)I2C0_EV_Handler_RAM,             /* 44, irq28   I2C0_EV handler            */
    (vect_t)I2C0_ERR_Handler_RAM,            /* 45, irq29   I2C0_ERR handler           */
    (vect_t)I2C1_EV_Handler_RAM,             /* 46, irq30   I2C1_EV handler            */
    (vect_t)I2C1_ERR_Handler_RAM,            /* 47, irq31   I2C1_ERR handler           */
    (vect_t)SPI0_I2S0_Handler_RAM,           /* 48, irq32   SPI0_I2S0 handler          */
    (vect_t)SPI1_I2S1_Handler_RAM,           /* 49, irq33   SPI1_I2S1 handler          */
    (vect_t)UART0_Handler_RAM,               /* 50, irq34   UART0 handler              */
    (vect_t)UART1_Handler_RAM,               /* 51, irq35   UART1 handler              */
    (vect_t)UART2_Handler_RAM,               /* 52, irq36   UART2 handler              */
    (vect_t)UART3_Handler_RAM,               /* 53, irq37   UART3 handler              */
    (vect_t)UART4_Handler_RAM,               /* 54, irq38   UART4 handler              */
    (vect_t)UART5_Handler_RAM,               /* 55, irq39   UART5 handler              */
    (vect_t)0,                               /* 56, irq40   Reserved                   */
    (vect_t)0,                               /* 57, irq41   Reserved                   */
    (vect_t)CRYPT_Handler_RAM,               /* 58, irq42   CRYPT handler              */
    (vect_t)ACMP0_Handler_RAM,               /* 59, irq43   ACMP0 handler              */
    (vect_t)ACMP1_Handler_RAM,               /* 60, irq44   ACMP1 handler              */
    (vect_t)SPI2_I2S2_Handler_RAM,           /* 61, irq45   SPI2_I2S2 handler          */
    (vect_t)0,                               /* 62, irq46   Reserved                   */
    (vect_t)EBI_Handler_RAM,                 /* 63, irq47   EBI handler                */
    (vect_t)TRNG_Handler_RAM,                /* 64, irq48   TRNG handler               */
    (vect_t)TSENSE_Handler_RAM,              /* 65, irq49   TSENSE handler             */
    (vect_t)EXTI0_Handler_RAM,               /* 66, irq50   EXTI0 handler              */
    (vect_t)EXTI1_Handler_RAM,               /* 67, irq51   EXTI1 handler              */
    (vect_t)EXTI2_Handler_RAM,               /* 68, irq52   EXTI2 handler              */
    (vect_t)EXTI3_Handler_RAM,               /* 69, irq53   EXTI3 handler              */
    (vect_t)EXTI4_Handler_RAM,               /* 70, irq54   EXTI4 handler              */
    (vect_t)EXTI5_Handler_RAM,               /* 71, irq55   EXTI5 handler              */
    (vect_t)EXTI6_Handler_RAM,               /* 72, irq56   EXTI6 handler              */
    (vect_t)EXTI7_Handler_RAM,               /* 73, irq57   EXTI7 handler              */
    (vect_t)EXTI8_Handler_RAM,               /* 74, irq58   EXTI8 handler              */
    (vect_t)EXTI9_Handler_RAM,               /* 75, irq59   EXTI9 handler              */
    (vect_t)EXTI10_Handler_RAM,              /* 76, irq60   EXTI10 handler             */
    (vect_t)EXTI11_Handler_RAM,              /* 77, irq61   EXTI11 handler             */
    (vect_t)EXTI12_Handler_RAM,              /* 78, irq62   EXTI12 handler             */
    (vect_t)EXTI13_Handler_RAM,              /* 79, irq63   EXTI13 handler             */
    (vect_t)EXTI14_Handler_RAM,              /* 80, irq64   EXTI14 handler             */
    (vect_t)EXTI15_Handler_RAM,              /* 81, irq65   EXTI15 handler             */
    (vect_t)DMA_Handler_RAM,                 /* 82, irq66   DMA handler                */
    (vect_t)ADC1_Handler_RAM,                /* 83, irq67   ADC1 handler               */
    (vect_t)DAC0_CH1_Handler_RAM,            /* 84, irq68   DAC0_CH1 handler           */
    (vect_t)QSPI_Handler_RAM,                /* 85, irq69   QSPI handler               */
    (vect_t)USB_INT_Handler_RAM,             /* 86, irq70   USB_INT handler            */
    (vect_t)USB_DMA_Handler_RAM,             /* 87, irq71   USB_DMA handler            */
    (vect_t)ACMP2_Handler_RAM,               /* 88, irq72   ACMP2 handler              */
};

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
