/*
----------------------------------------------------------------------
File   : es32f36xx.ld
Purpose: Link file for es32f36xx FLASH
-------- END-OF-HEADER -----------------------------------------------
*/

OUTPUT_FORMAT("elf32-littlearm","elf32-littlearm","elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(__vector)

/*********************************************************************
*
*       Define stack sites here
*/


MEMORY
{
FLASH1 (rx) : ORIGIN = 0x0 , LENGTH = 524288
FLASH2 (rx) : ORIGIN = 0x0 , LENGTH = 0x0
FLASH3 (rx) : ORIGIN = 0x0 , LENGTH = 0x0

RAM1 (wx) : ORIGIN = 0x20000000 , LENGTH = 98304
RAM2 (wx) : ORIGIN = 0x20000000 , LENGTH = 0x0
RAM3 (wx) : ORIGIN = 0x20000000 , LENGTH = 0x0
RAM4 (wx) : ORIGIN = 0x20017800 , LENGTH = 0x800

}

SECTIONS
{
  .text1 : 
  {
    KEEP( *(.vectors));
	*(.text*)
	. = ALIGN(4);
    KEEP(*(.init));
    KEEP(*(.fini));
    . = ALIGN(4);
    *(.glue_7t);
    . = ALIGN(4);
    *(.glue_7);
    . = ALIGN(4);

	/* .ctors */
	*crtbegin.o(.ctors)
	*crtbegin?.o(.ctors)
	*(EXCLUDE_FILE(*crtend?.o *crtend.o) .ctors)
	*(SORT(.ctors.*))
	*(.ctors)

	/* .dtors */
 	*crtbegin.o(.dtors)
 	*crtbegin?.o(.dtors)
 	*(EXCLUDE_FILE(*crtend?.o *crtend.o) .dtors)
 	*(SORT(.dtors.*))
 	*(.dtors)

	*(.rodata*)

	KEEP(*(.eh_frame*))	
	
  } > FLASH1
  
  . = ALIGN(4);
  .init_array :
  {
	/* preinit data */
	PROVIDE_HIDDEN (__preinit_array_start = .);
	KEEP(*(.preinit_array*))
	PROVIDE_HIDDEN (__preinit_array_end = .);
	
	__init_array_start = .;
	KEEP(*(.init_array*))
	__init_array_end = .;
	
	
  } > FLASH1
  
  
  . = ALIGN(4);
  .ARM.extab : 
	{
		*(.ARM.extab* .gnu.linkonce.armextab.*)
	} > FLASH1
	. = ALIGN(4);
	
	__exidx_start = .;
	.ARM.exidx :
	{
		*(.ARM.exidx* .gnu.linkonce.armexidx.*)
	} > FLASH1
	__exidx_end = .;
	. = ALIGN(4);
	

	/* Location counter can end up 2byte aligned with narrow Thumb code but
	   __etext is assumed by startup code to be the LMA of a section in RAM
	   which must be 4byte aligned */
	_etext = ALIGN (4);
	_sidata = .; 


  .data : AT (_etext)
  {
	__data_start__ = .;
	*(vtable)
	. = ALIGN(4);
	*(.data*)
	. = ALIGN(4);

	KEEP(*(.jcr*))
	. = ALIGN(4);
	/* All data end */
	__data_end__ = .;
  
  } > RAM1

  _my_rom_end  = _etext + SIZEOF(.data);

  . = ALIGN(4);
  _edata = . ;
  PROVIDE (edata = .);

  .bss : AT(_edata)
  {
    PROVIDE (__bss_start__ = .);
    *(.bss*)
    *(COMMON)
    . = ALIGN(4);
    PROVIDE (__bss_end__ = .);

    . = ALIGN(256);

  } > RAM1

  _ram_current = ALIGN(4);
   .heap : AT(_ram_current)
  {
    PROVIDE (__heap_start = .);
    *(.heap*)
    PROVIDE (__heap_end__ = .);
  } > RAM1 

  _ram_current = ALIGN(4);
  .stack : AT(_ram_current)
  {
    PROVIDE (__stack_start = .);
    *(.stack)
    PROVIDE (__stack_end__ = .);
  } > RAM4 

  .ram1_text : AT (_my_rom_end) 
  {
    . = ALIGN(4);
    _my_ram1_start = .;
  } > RAM1 
  _my_ram1_size = SIZEOF(.ram1_text);
  
  .ram2_text : AT (_my_rom_end + _my_ram1_size) 
  {
    . = ALIGN(4);
    _my_ram2_start = .;
  } > RAM2 
  _my_ram2_size = SIZEOF(.ram2_text);
  
  .ram3_text : AT (_my_rom_end + _my_ram1_size + _my_ram2_size) 
  {
    . = ALIGN(4);
    _my_ram3_start = .;
  } > RAM3 
  _my_ram3_size = SIZEOF(.ram3_text);
  

}
