/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *          20 August 2021  Lisq            增加 I2C1_ERR_IRQn 使能
 *          27 July 2022    Zhuxf           适配ES-PDS-ES32F3696LX开发板
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
md_i2c_init_t g_md_i2c;
uint8_t g_recv_buf[20];
uint32_t g_recv_len = sizeof(g_recv_buf);
uint32_t g_recv_inc = 0U;
uint8_t g_send_buf[20];
uint32_t g_send_len = sizeof(g_send_buf);
uint32_t g_send_inc = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */


/**
  * @brief  Initializate pin of i2c module.
  * @retval None
  */
void init_i2c_pin(void)
{
    md_gpio_init_t md_gpio;
    md_gpio_init_struct(&md_gpio);

    /* Initialize scl pin */
    md_gpio.mode  = MD_GPIO_MODE_INPUT;
    md_gpio.odos  = MD_GPIO_OPEN_DRAIN;
    md_gpio.pupd  = MD_GPIO_PUSH_UP;
    md_gpio.nodrv = MD_GPIO_OUT_DRIVE_1;
    md_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    md_gpio.type  = MD_GPIO_TYPE_CMOS;
    md_gpio.func  = MD_GPIO_FUNC_5;
    md_gpio_init(I2C1_SCL_PORT, I2C1_SCL_PIN, &md_gpio);

    /* Initialize sda pin */
    md_gpio.mode  = MD_GPIO_MODE_OUTPUT;
    md_gpio.odos  = MD_GPIO_OPEN_DRAIN;
    md_gpio.pupd  = MD_GPIO_PUSH_UP;
    md_gpio.nodrv = MD_GPIO_OUT_DRIVE_1;
    md_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    md_gpio.type  = MD_GPIO_TYPE_CMOS;
    md_gpio.func  = MD_GPIO_FUNC_5;
    md_gpio_init(I2C1_SDA_PORT, I2C1_SDA_PIN, &md_gpio);

    return;
}

void init_i2c(void)
{
    md_i2c_struct_init(&g_md_i2c);
    g_md_i2c.module       = MD_I2C_MODULE_SLAVE;
    g_md_i2c.addr_mode    = MD_I2C_ADDR_7BIT;
    g_md_i2c.clk_speed    = MD_I2C_FAST_MODE_MAX_CLK;
    g_md_i2c.dual_addr    = MD_I2C_DUALADDR_ENABLE;
    g_md_i2c.general_call = MD_I2C_GENERALCALL_DISABLE;
    g_md_i2c.no_stretch   = MD_I2C_NOSTRETCH_DISABLE;
    g_md_i2c.own_addr1    = OWN_ADDR << 1;
    md_i2c_init(I2C1, &g_md_i2c);

    md_i2c_set_receive_fifo_thread(I2C1, 0);
    md_i2c_set_transmit_fifo_thread(I2C1, 0);

    md_i2c_set_receive_fifo_reset(I2C1);
    md_i2c_set_transmit_fifo_reset(I2C1);

    /* Enable address match interrupt */
    md_i2c_enable_it_addr(I2C1);

    /* Enable NACK interrupt */
    md_i2c_enable_it_nack(I2C1);

    /* Enable stop interrupt */
    md_i2c_enable_it_stop(I2C1);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);

    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    init_i2c_pin();

    init_i2c();

    /* Enable I2C1 event interrupt */
    md_mcu_irq_config(I2C1_EV_IRQn, 3, 3, ENABLE);
    /* Enable I2C1 error interrupt */
    md_mcu_irq_config(I2C1_ERR_IRQn, 3, 3, ENABLE);

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
