/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *          27 July 2022    Zhuxf           适配ES-PDS-ES32F3696LX开发板
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

md_i2c_init_t g_md_i2c;
uint8_t g_recv_buf[20];
uint8_t g_recv_len = sizeof(g_recv_buf);
uint8_t g_send_buf[20];
uint8_t g_send_len = sizeof(g_send_buf);
uint8_t g_recv_inc;
uint8_t g_send_inc;
md_dma_descriptor_t g_dma0_ctrl_base[2] __attribute__((aligned(512)));
md_dma_config_t g_dma_tx_config, g_dma_rx_config;
/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of i2c module.
  * @retval None
  */
void init_i2c_pin(void)
{
    md_gpio_init_t md_gpio;
    md_gpio_init_struct(&md_gpio);

    /* Initialize scl pin */
    md_gpio.mode  = MD_GPIO_MODE_INPUT;
    md_gpio.odos  = MD_GPIO_OPEN_DRAIN;
    md_gpio.pupd  = MD_GPIO_PUSH_UP;
    md_gpio.nodrv = MD_GPIO_OUT_DRIVE_1;
    md_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    md_gpio.type  = MD_GPIO_TYPE_CMOS;
    md_gpio.func  = MD_GPIO_FUNC_5;
    md_gpio_init(I2C1_SCL_PORT, I2C1_SCL_PIN, &md_gpio);

    /* Initialize sda pin */
    md_gpio.mode  = MD_GPIO_MODE_OUTPUT;
    md_gpio.odos  = MD_GPIO_OPEN_DRAIN;
    md_gpio.pupd  = MD_GPIO_PUSH_UP;
    md_gpio.nodrv = MD_GPIO_OUT_DRIVE_1;
    md_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    md_gpio.type  = MD_GPIO_TYPE_CMOS;
    md_gpio.func  = MD_GPIO_FUNC_5;
    md_gpio_init(I2C1_SDA_PORT, I2C1_SDA_PIN, &md_gpio);

    return;
}

/**
  * @brief  dma_start_tx init.
  * @param  None
  * @retval None
  */
void dma_send_tx(void)
{
    memset(&g_dma_tx_config, 0x0, sizeof(md_dma_config_t));
    md_dma_set_ctrlbase((uint32_t)g_dma0_ctrl_base);

    /* Enable DMA */
    md_dma_enable();

    md_dma_config_struct(&g_dma_tx_config);
    g_dma_tx_config.data_width = MD_DMA_DATA_SIZE_BYTE;
    g_dma_tx_config.src_inc    = MD_DMA_DATA_INC_BYTE;
    g_dma_tx_config.dst_inc    = MD_DMA_DATA_INC_NONE;
    g_dma_tx_config.R_power    = MD_DMA_R_POWER_1;
    g_dma_tx_config.primary    = ENABLE;
    g_dma_tx_config.burst      = ENABLE;
    g_dma_tx_config.high_prio  = DISABLE;
    g_dma_tx_config.interrupt  = ENABLE;
    g_dma_tx_config.channel    = 0;
    g_dma_tx_config.src        = (void *)(g_send_buf);
    g_dma_tx_config.dst        = (void *)(&I2C1->TXDATA);
    g_dma_tx_config.size       = g_send_len;
    g_dma_tx_config.msel       = MD_DMA_MSEL_I2C1;
    g_dma_tx_config.msigsel    = MD_DMA_MSIGSEL_I2C_TXEMPTY;
    md_dma_config_base(DMA0, MD_DMA_CYCLE_CTRL_BASIC, &g_dma_tx_config);
}

/**
  * @brief  dma_start_rx init.
  * @param  None
  * @retval None
  */
void dma_recv_rx(void)
{
    memset(&g_dma_rx_config, 0x0, sizeof(md_dma_config_t));
    md_dma_set_ctrlbase((uint32_t)g_dma0_ctrl_base);

    /* Enable DMA */
    md_dma_enable();

    md_dma_config_struct(&g_dma_rx_config);
    /* initialize DMA */
    g_dma_rx_config.data_width = MD_DMA_DATA_SIZE_BYTE;
    g_dma_rx_config.src_inc    = MD_DMA_DATA_INC_NONE;
    g_dma_rx_config.dst_inc    = MD_DMA_DATA_INC_BYTE;
    g_dma_rx_config.R_power    = MD_DMA_R_POWER_1;
    g_dma_rx_config.primary    = ENABLE;
    g_dma_rx_config.burst      = ENABLE;
    g_dma_rx_config.high_prio  = DISABLE;
    g_dma_rx_config.interrupt  = ENABLE;
    g_dma_rx_config.channel    = 1;
    g_dma_rx_config.src        = (void *)(&I2C1->RXDATA);
    g_dma_rx_config.dst        = (void *)(g_recv_buf);
    g_dma_rx_config.size       = g_recv_len;
    g_dma_rx_config.msel       = MD_DMA_MSEL_I2C1;
    g_dma_rx_config.msigsel    = MD_DMA_MSIGSEL_I2C_RNR;
    md_dma_config_base(DMA0, MD_DMA_CYCLE_CTRL_BASIC, &g_dma_rx_config);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);

    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    init_i2c_pin();

    md_i2c_struct_init(&g_md_i2c);
    g_md_i2c.module       = MD_I2C_MODULE_SLAVE;
    g_md_i2c.addr_mode    = MD_I2C_ADDR_7BIT;
    g_md_i2c.clk_speed    = MD_I2C_FAST_MODE_MAX_CLK;
    g_md_i2c.dual_addr    = MD_I2C_DUALADDR_ENABLE;
    g_md_i2c.general_call = MD_I2C_GENERALCALL_DISABLE;
    g_md_i2c.no_stretch   = MD_I2C_NOSTRETCH_DISABLE;
    g_md_i2c.own_addr1    = OWN_ADDR << 1;
    md_i2c_init(I2C1, &g_md_i2c);

    md_i2c_set_receive_fifo_thread(I2C1, 0);
    md_i2c_set_transmit_fifo_thread(I2C1, 0);

    /* Enable I2C1 event interrupt */
    md_mcu_irq_config(I2C1_EV_IRQn, 3, 3, ENABLE);
    /* Enable address match interrupt */
    md_i2c_enable_it_addr(I2C1);

    dma_send_tx();
    dma_recv_rx();

    /* Enable DMA event interrupt */
    md_mcu_irq_config(DMA_IRQn, 0, 0, ENABLE);

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
