/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *          3  Sep. 2021    Lisq            I2C引脚改为TTL模式
 *          17 July 2022    zhuxf           1.使用“自动结束模式”
 *                                          2.使用“总线忙标志“判断总线是否空闲
 *                                          3.功能改为先读后写
 *                                          4.使能NACK接收中断
 *                                          5.适配ES-PDS-ES32F3696LX开发板
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
md_i2c_init_t g_md_i2c;
uint8_t g_recv_buf[20];
uint8_t g_recv_len = sizeof(g_recv_buf);
uint8_t g_recv_inc = 0U;
uint8_t g_send_buf[20];
uint8_t g_send_len = sizeof(g_send_buf);
uint8_t g_send_inc = 0U;
uint8_t g_complete = 1U;
uint8_t g_error_flag = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of i2c module.
  * @retval None
  */
void init_i2c_pin(void)
{
    md_gpio_init_t md_gpio;
    md_gpio_init_struct(&md_gpio);

    /* Initialize scl pin */
    md_gpio.mode  = MD_GPIO_MODE_OUTPUT;
    md_gpio.odos  = MD_GPIO_OPEN_DRAIN;
    md_gpio.pupd  = MD_GPIO_PUSH_UP;
    md_gpio.nodrv = MD_GPIO_OUT_DRIVE_1;
    md_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    md_gpio.type  = MD_GPIO_TYPE_CMOS;
    md_gpio.func  = MD_GPIO_FUNC_5;
    md_gpio_init(I2C1_SCL_PORT, I2C1_SCL_PIN, &md_gpio);

    /* Initialize sda pin */
    md_gpio.mode  = MD_GPIO_MODE_OUTPUT;
    md_gpio.odos  = MD_GPIO_OPEN_DRAIN;
    md_gpio.pupd  = MD_GPIO_PUSH_UP;
    md_gpio.nodrv = MD_GPIO_OUT_DRIVE_1;
    md_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    md_gpio.type  = MD_GPIO_TYPE_CMOS;
    md_gpio.func  = MD_GPIO_FUNC_5;
    md_gpio_init(I2C1_SDA_PORT, I2C1_SDA_PIN, &md_gpio);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint16_t cnt;

    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);

    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    init_i2c_pin();

    md_i2c_struct_init(&g_md_i2c);
    /* Initialize I2C */
    g_md_i2c.module       = MD_I2C_MODULE_MASTER;
    g_md_i2c.addr_mode    = MD_I2C_ADDR_7BIT;
    g_md_i2c.clk_speed    = MD_I2C_FAST_MODE_MAX_CLK;
    g_md_i2c.dual_addr    = MD_I2C_DUALADDR_DISABLE;
    g_md_i2c.general_call = MD_I2C_GENERALCALL_DISABLE;
    g_md_i2c.no_stretch   = MD_I2C_NOSTRETCH_DISABLE;
    g_md_i2c.own_addr1    = 0x2D << 1;
    md_i2c_init(I2C1, &g_md_i2c);

    md_i2c_set_transmit_fifo_reset(I2C1);
    md_i2c_set_receive_fifo_reset(I2C1);
    md_i2c_set_receive_fifo_thread(I2C1, 0);
    md_i2c_set_transmit_fifo_thread(I2C1, 0);

    /* set slave address */
    md_i2c_set_slave_addr(I2C1, SLAVE_ADDR << 1);
    /* enable automatic end and automatically send stop bit */
    md_i2c_enable_auto_end(I2C1);

    md_i2c_clear_flag_txth(I2C1);
    md_i2c_clear_flag_rxth(I2C1);

    /* Enable RXTH interrupt */
    md_i2c_enable_it_rxth(I2C1);
    /* Enable NACK interrupt */
    md_i2c_enable_it_nack(I2C1);

    /* Enable I2C1 event interrupt */
    md_mcu_irq_config(I2C1_EV_IRQn, 3, 3, ENABLE);

    while (1)
    {
        g_complete = 0;
        /* read */
        /* set transmission length */
        md_i2c_set_transmit_length(I2C1, g_recv_len);
        /* select master read mode */
        md_i2c_enable_master_read(I2C1);
        /* produce start signal */
        md_i2c_set_start(I2C1);

        cnt = 40000;
        while (!g_complete && (--cnt));

        cnt = 40000;
        while (md_i2c_is_active_busy(I2C1) && (--cnt));

        memcpy(g_send_buf, g_recv_buf, g_recv_len);

        g_complete = 0;
        /* write */
        g_error_flag = 0;
        /* set transmission length */
        md_i2c_set_transmit_length(I2C1, g_send_len);
        /* select master write mode */
        md_i2c_enable_master_write(I2C1);
        /* produce start signal */
        md_i2c_set_start(I2C1);

        /* Enable TXTH interrupt */
        md_i2c_enable_it_txth(I2C1);

        cnt = 40000;
        while (!g_complete && (--cnt));

        /* Disable TXTH interrupt */
        md_i2c_disable_it_txth(I2C1);

        cnt = 40000;
        while (md_i2c_is_active_busy(I2C1) && (--cnt));

        md_delay_1ms(2000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
