/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"
#include "md_utils.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}

/**
  * @brief  I2C Event IRQ handler
  * @retval None
  */
void I2C1_EV_Handler(void)
{
    uint16_t cnt;

    /* if tx data is under fifo treshold, send data */
    if (md_i2c_mask_it_txth(I2C1))
    {
        md_i2c_clear_flag_txth(I2C1);

        cnt = 40000;

        while (md_i2c_is_active_txf(I2C1) && (--cnt));

        md_i2c_set_tx_reg_data(I2C1, g_send_buf[g_send_inc]);

        g_send_inc++;

        if (g_send_inc >= g_send_len)
        {
            g_send_inc = 0;
            g_complete = 1;
        }
    }

    /* if rx data is over fifo threshold, transmit data */
    if (md_i2c_mask_it_rxth(I2C1))
    {
        md_i2c_clear_flag_rxth(I2C1);

        cnt = 40000;

        while (!md_i2c_is_active_rxe(I2C1) && (--cnt))
        {
            g_recv_buf[g_recv_inc] = md_i2c_get_rx_reg_data(I2C1);

            g_recv_inc++;
        }

        if (g_recv_inc >= g_recv_len)
        {
            g_recv_inc = 0;
            g_complete = 1;
        }
    }

}

/**
  * @brief  I2C Error IRQ handler
  * @retval None
  */
void I2C1_ERR_Handler(void)
{
    /* If NACK is received when writing data */
    if (md_i2c_mask_it_nack(I2C1))
    {
        md_i2c_clear_flag_nack(I2C1);
        g_error_flag = 1;
    }
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
