/**********************************************************************************
 *
 * @file    eeprom.c
 * @brief   SPI Flash file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "eeprom.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

static md_i2c_init_t s_i2c;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

static void init_i2c_pin(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief i2c function
  * @retval None.
  */
void init_mcu_i2c(void)
{
    init_i2c_pin();

    s_i2c.clk_speed    = MD_I2C_FAST_MODE_MAX_CLK; /*CLK 400000*/
    s_i2c.own_addr1    = 0x2D << 1;
    s_i2c.addr_mode    = MD_I2C_ADDR_7BIT;
    s_i2c.general_call = MD_I2C_GENERALCALL_DISABLE;
    s_i2c.no_stretch   = MD_I2C_NOSTRETCH_ENABLE;

    md_i2c_init(I2C0, &s_i2c);  /*According to the initialization parameter I2C module*/
}

/**
  * @brief  Initializate i2c pin
  * @retval None.
  */
static void init_i2c_pin(void)
{
    md_gpio_init_t md_gpio;

    md_gpio.type  = MD_GPIO_TYPE_CMOS;
    md_gpio.odos  = MD_GPIO_OPEN_DRAIN;
    md_gpio.pupd  = MD_GPIO_PUSH_UP;
    md_gpio.nodrv = MD_GPIO_OUT_DRIVE_1;
    md_gpio.flt   = MD_GPIO_FILTER_DISABLE;

    md_gpio.func  = MD_GPIO_FUNC_5;
    md_gpio.mode  = MD_GPIO_MODE_OUTPUT;
    md_gpio_init(I2C_SCL_PORT, I2C_SCL_PIN, &md_gpio);   /*Initialize PB6 is SCL pin*/
    md_gpio_init(I2C_SDA_PORT, I2C_SDA_PIN, &md_gpio);   /*Initialize PB7 for SDA pin*/
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
