/**********************************************************************************
 *
 * @file    eeprom.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __EEPROM_H__
#define   __EEPROM_H__

/* Includes ------------------------------------------------------------------ */

#include "md_utils.h"
#include "md_i2c.h"
#include "md_gpio.h"

/* Private Macros ------------------------------------------------------------ */
#define I2C_SCL_PORT GPIOB
#define I2C_SCL_PIN  MD_GPIO_PIN_6
#define I2C_SDA_PORT GPIOB
#define I2C_SDA_PIN  MD_GPIO_PIN_7

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

void init_mcu_i2c(void);

#endif    /*__EEPROM_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
