/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *          3 Sep. 2021     Lisq            去除I2C中断使能
 *          27 July 2022    Zhuxf           适配ES-PDS-ES32F3696LX开发板
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uint8_t g_recv_buf[20];
uint8_t g_recv_len = sizeof(g_recv_buf);
uint8_t g_send_buf[20];
uint8_t g_send_len = sizeof(g_send_buf);
i2c_handle_t g_ald_i2c;

uint8_t g_tx_complete;
uint8_t g_rx_complete;
/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of i2c module.
  * @retval None
  */
void init_i2c_pin(void)
{
    gpio_init_t ald_gpio;
    memset(&ald_gpio, 0, sizeof(gpio_init_t));

    /* Initialize scl pin */
    ald_gpio.mode = GPIO_MODE_OUTPUT;
    ald_gpio.odos = GPIO_OPEN_DRAIN;
    ald_gpio.pupd = GPIO_PUSH_UP;
    ald_gpio.nodrv = GPIO_OUT_DRIVE_1;
    ald_gpio.flt  = GPIO_FILTER_DISABLE;
    ald_gpio.type = GPIO_TYPE_CMOS;
    ald_gpio.func = GPIO_FUNC_5;
    ald_gpio_init(I2C_SCL_PORT, I2C_SCL_PIN, &ald_gpio);

    /* Initialize sda pin */
    ald_gpio.mode = GPIO_MODE_OUTPUT;
    ald_gpio.odos = GPIO_OPEN_DRAIN;
    ald_gpio.pupd = GPIO_PUSH_UP;
    ald_gpio.nodrv = GPIO_OUT_DRIVE_1;
    ald_gpio.flt  = GPIO_FILTER_DISABLE;
    ald_gpio.type = GPIO_TYPE_CMOS;
    ald_gpio.func = GPIO_FUNC_5;
    ald_gpio_init(I2C_SDA_PORT, I2C_SDA_PIN, &ald_gpio);

    return;
}

/*The host send complete*/
void master_tx_complete(i2c_handle_t *arg)
{
    g_tx_complete = 1;
    return;
}

/*The host receive complete*/
void master_rx_complete(i2c_handle_t *arg)
{
    g_rx_complete = 1;
    return;
}
/**
  * @brief  Send message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_send_complete(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_recv_complete(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_error(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint16_t cnt = 4000U;

    /* Initialize ALD */
    ald_cmu_init();

    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);

    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Initialize i2c pin */
    init_i2c_pin();

    /*Interrupt priority level and make configuration can interrupt*/
    ald_mcu_irq_config(DMA_IRQn, 1, 1, ENABLE);
    /* clear i2c_handle_t structure */
    memset(&g_ald_i2c, 0, sizeof(i2c_handle_t));
    /* Initialize i2c */
    g_ald_i2c.perh = I2C1;
    g_ald_i2c.init.module       = I2C_MODULE_MASTER;
    g_ald_i2c.init.addr_mode    = I2C_ADDR_7BIT;
    g_ald_i2c.init.clk_speed    = 400000;
    g_ald_i2c.init.dual_addr    = I2C_DUALADDR_DISABLE;
    g_ald_i2c.init.general_call = I2C_GENERALCALL_DISABLE;
    g_ald_i2c.init.no_stretch   = I2C_NOSTRETCH_DISABLE;
    g_ald_i2c.init.own_addr1    = 0x2D << 1;
    g_ald_i2c.master_rx_cplt_cbk = master_rx_complete;
    g_ald_i2c.master_tx_cplt_cbk = master_tx_complete;
    ald_i2c_init(&g_ald_i2c);

    SET_BIT(g_ald_i2c.perh->FCON, I2C_FCON_TXFRST_MSK);
    SET_BIT(g_ald_i2c.perh->FCON, I2C_FCON_RXFRST_MSK);

    while (1)
    {
        /* master receive by dma */
        g_rx_complete = 0;
        ald_i2c_master_recv_by_dma(&g_ald_i2c, 0x2D << 1, g_recv_buf, g_recv_len, 1);

        while (!g_rx_complete && (--cnt));

        memcpy(g_send_buf, g_recv_buf, g_recv_len);

        /* master send by dma */
        g_tx_complete = 0;
        ald_i2c_master_send_by_dma(&g_ald_i2c, 0x2D << 1, g_send_buf, g_send_len, 0);

        cnt = 40000;

        while (!g_tx_complete && (--cnt));

        ald_delay_ms(2000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
