/**********************************************************************************
 *
 * @file    uart.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <stdio.h>
#include "uart.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

static uart_handle_t s_uart;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

static void init_uart_pin(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  uart function
  * @retval None.
  */
void init_mcu_uart(void)
{
    init_uart_pin();

    s_uart.perh             = UART2;
    s_uart.init.mode        = UART_MODE_UART;
    s_uart.init.baud        = 115200;       /*115200 8 1 N*/
    s_uart.init.word_length = UART_WORD_LENGTH_8B;
    s_uart.init.stop_bits   = UART_STOP_BITS_1;
    s_uart.init.parity      = UART_PARITY_NONE;
    s_uart.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&s_uart);         /*Initialization and enabled UART0*/
}

/**
  * @brief  uart pin function
  * @retval None.
  */
static void init_uart_pin(void)
{
    gpio_init_t ald_gpio;

    ald_gpio.func = GPIO_FUNC_3;
    ald_gpio.mode = GPIO_MODE_OUTPUT;
    ald_gpio.odos = GPIO_PUSH_PULL;
    ald_gpio.pupd = GPIO_PUSH_UP;
    ald_gpio.type = GPIO_TYPE_CMOS;
    ald_gpio.podrv = GPIO_OUT_DRIVE_1;
    ald_gpio.nodrv = GPIO_OUT_DRIVE_1;
    ald_gpio.flt  = GPIO_FILTER_DISABLE;
    ald_gpio_init(UART_TX_PORT, UART_TX_PIN, &ald_gpio);     /*Initializes the TX pin*/

    ald_gpio.mode = GPIO_MODE_INPUT;
    ald_gpio_init(UART_RX_PORT, UART_RX_PIN, &ald_gpio);     /*Apart from the pin direction for input configuration is the same as the TX pin*/
}

#ifdef __GNUC__     /* GCC Compiler */
int _write(int file, const void *ptr, int len)
{
    uint16_t cnt;
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        if (*ptr_char == '\n')
        {
            cnt = 4000;

            while (!ald_uart_get_status(&s_uart, UART_STATUS_TFEMPTY) && (--cnt));

            s_uart.perh->TXBUF = '\r';
        }

        cnt = 4000;

        while (!ald_uart_get_status(&s_uart, UART_STATUS_TFEMPTY) && (--cnt));

        s_uart.perh->TXBUF = *ptr_char++;
    }

    return len;
}

void *_sbrk(intptr_t increment)
{
    extern char end asm("end");
    /* Defined by the linker. */
    static char *heap_end;
    char *prev_heap_end;

    heap_end += increment;

    return (void *)prev_heap_end;
}

void _read()
{

}

void _lseek()
{

}

void _close()
{

}

void _fstat()
{

}

void _isatty()
{

}

void _getpid()
{

}

void _kill()
{

}

void _exit()
{

}

#else
int fputc(int c, FILE *f)
{
    uint16_t cnt = 4000U;

    while (!ald_uart_get_status(&s_uart, UART_STATUS_TFEMPTY) && (--cnt))
    {

    }

    s_uart.perh->TXBUF = c;

    return c;
}

#endif /* __GNUC__ */

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
