/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *          27 July 2022    Zhuxf           适配ES-PDS-ES32F3696LX开发板
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include <stdio.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

#define SLAVE_ADDR  0xA0    /*Definition from the machine address*/
#define MEM_ADDR    0x00    /*Define the machine from the initial memory address*/
#define ADDR_SIZE   I2C_MEMADD_SIZE_8BIT    /*Definition from the machine store address digits, eight by default*/
#define TIMEOUT_E2     1000    /*Define the timeout*/

/* Private Variables --------------------------------------------------------- */

static char s_eeprom_txbuf[16] = "eeprom example!";     /*Length must be no more than one page (16 bytes)*/
static char s_eeprom_rxbuf[16];

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);    /*Can make the frequency doubling, by the crystal three times the frequency of vibration to 48 MHZ*/
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);    /*Choose the frequency doubling the clock for the system clock*/
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);    /*Can make all the peripheral clock*/

    init_mcu_uart();    /*To initialize the UART module*/
    init_mcu_i2c();     /*Initialize the I2C module*/

    printf("\r\nThe date written to eeprom address %d is -> %s\r\n", MEM_ADDR, s_eeprom_txbuf);

    if ((i2c_write_device(SLAVE_ADDR, MEM_ADDR, ADDR_SIZE, s_eeprom_txbuf, strlen(s_eeprom_txbuf) + 1, TIMEOUT_E2)) != OK) /*Write the data*/
        printf("Write ERROR!\r\n");

    ald_delay_ms(10);  /*Waiting for the written to complete*/

    i2c_read_device(SLAVE_ADDR, MEM_ADDR, ADDR_SIZE, s_eeprom_rxbuf, strlen(s_eeprom_txbuf) + 1, TIMEOUT_E2); /*Read the data*/
    printf("The data read from eeprom address %d is  -> %s\r\n", MEM_ADDR, s_eeprom_rxbuf);

    if (!memcmp(s_eeprom_txbuf, s_eeprom_rxbuf, strlen(s_eeprom_txbuf) + 1))   /*Data is written and read*/
        printf("Read OK!\r\n");
    else
        printf("Read ERROR!\r\n");

    while (1)
        ;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
