/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"
#include "i2c.h"
#include "usart.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */
static char     s_send_buf[] = "e2rom example\r\n";
static uint32_t s_send_len = sizeof(s_send_buf);
static char     s_recv_buf[32] = {0};

/* Public Variables ---------------------------------------------------------- */
eeprom_read_write_handler g_eeprom;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/*The main function*/
int main(void)
{
    /*Configure the system clock*/
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 24000000);

    /*Initialize the SysTick interrupt*/
    md_init_1ms_tick();

    /*I2C clock can make*/
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    init_mcu_usart();
    /*I2C initialization*/
    initialize_i2c_master();

    /*I2C can make*/
    MD_I2C_ENABLE(I2C1);
    
    /* config e2rom address */
    g_eeprom.slave_addr = SLAVE_ADDR;
    g_eeprom.mem_addr = MEM_ADDR;
    printf("demo start\r\n");
    
    /* config for write data */
    g_eeprom.w_buf = s_send_buf;
    g_eeprom.w_size = s_send_len;
    write_i2c_device(&g_eeprom);
    printf("write content is %s\r\n", s_send_buf);
    md_delay_1ms(10);
    
    /* config for read data */
    g_eeprom.r_buf = s_recv_buf;
    g_eeprom.r_size = s_send_len; 
    read_i2c_device(&g_eeprom);
    printf("read content is %s\r\n", s_recv_buf);
    if (!memcmp(g_eeprom.r_buf, g_eeprom.w_buf, g_eeprom.w_size))   /*Data is written and read*/
    {
        printf("Verify OK!\r\n");
    }
    else
    {
        printf("Verify ERROR!\r\n");
    }
    printf("demo finished\r\n");

    while (1);
}

/**
  * @} Examples_I2C
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
