/**********************************************************************************
 *
 * @file    i2c.h
 * @brief   header file of i2c.c
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __I2C_H__
#define   __I2C_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"

/* Exported Types ------------------------------------------------------------ */
/**
  * @brief Master Transmission Request Direction Definition
  */
typedef enum
{
    I2C_REQUEST_WRITE = 0x00,
    I2C_REQUEST_READ  = 0x01,
} read_write_order_t;

/**
  *@brief eeprom_read_write
  */
typedef struct eeprom_read_write_t
{
    uint32_t slave_addr ;
    uint32_t mem_addr;
    char *r_buf;
    char *w_buf;
    uint32_t r_size;
    uint32_t w_size;
} eeprom_read_write_handler;


/* Exported Functions -------------------------------------------------------- */
void initialize_i2c_master(void);
uint32_t read_i2c_device(eeprom_read_write_handler *i2c_device);
uint32_t write_i2c_device(eeprom_read_write_handler *i2c_device);

/* Exported Macros ----------------------------------------------------------- */
/* Exported Variables -------------------------------------------------------- */
extern eeprom_read_write_handler g_eeprom;

/* Exported Constants -------------------------------------------------------- */
#endif  /* __I2C_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
