/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *          3 Sep. 2021     Lisq            I2C引脚改为TTL模式
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */ 
uint8_t  g_recv_buf[20];
uint8_t  g_send_buf[20];

volatile uint8_t g_read_or_write;
volatile uint8_t g_finish;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/*Host mode communication pins initialization function*/
void init_i2c_pin(void)
{
    md_gpio_init_t gpio_config;

    /*The host SCL pins initialization*/
    gpio_config.mode = MD_GPIO_MODE_OUTPUT;
    gpio_config.odos = MD_GPIO_OPEN_DRAIN;    /*Open drain output*/
    gpio_config.pupd = MD_GPIO_PUSH_UP;
    gpio_config.podrv = MD_GPIO_OUT_DRIVE_6;
    gpio_config.nodrv = MD_GPIO_OUT_DRIVE_6;
    gpio_config.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_config.type = MD_GPIO_TYPE_CMOS;
    gpio_config.func = MD_GPIO_FUNC_5;
    md_gpio_init(I2C1_SCL_PORT, I2C1_SCL_PIN, &gpio_config);

    /*Initialize the host SDA pin*/
    gpio_config.mode = MD_GPIO_MODE_OUTPUT;
    gpio_config.odos = MD_GPIO_OPEN_DRAIN;    /*Open drain output*/
    gpio_config.pupd = MD_GPIO_PUSH_UP;
    gpio_config.podrv = MD_GPIO_OUT_DRIVE_6;
    gpio_config.nodrv = MD_GPIO_OUT_DRIVE_6;
    gpio_config.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_config.type = MD_GPIO_TYPE_CMOS;
    gpio_config.func = MD_GPIO_FUNC_5;
    md_gpio_init(I2C1_SDA_PORT, I2C1_SDA_PIN, &gpio_config);

    return;
}

/*I2C initialization function*/
void initialize_i2c_master(void)
{
    md_i2c_init_t i2c_config;
    /*Will the I2C initialization structure is set to the default values*/
    md_i2c_struct_init(&i2c_config);

    /*User configuration I2C*/
    i2c_config.addr_mode = MD_I2C_ADDR_7BIT;
    i2c_config.clk_speed = 100000;
    i2c_config.dual_addr = MD_I2C_DUALADDR_DISABLE;
    i2c_config.duty = MD_I2C_DUTYCYCLE_16_9;
    i2c_config.general_call = MD_I2C_GENERALCALL_DISABLE;
    i2c_config.no_stretch = MD_I2C_NOSTRETCH_DISABLE;
    i2c_config.own_addr1 = 0x5A;

    /*Initialize the I2C*/
    md_i2c_init(I2C1, &i2c_config);
    return;
}

/*The main function*/
int main(void)
{
    uint16_t cnt;
    /*Configure the system clock*/
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC_6, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);

    /*Initialize the SysTick interrupt*/
    md_init_1ms_tick();

    /*I2C clock can make*/
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_i2c1();
    SYSCFG_LOCK();

    /*Interrupt priority level*/
    NVIC_SetPriority(I2C1_IRQn, 0);
    NVIC_EnableIRQ(I2C1_IRQn);

    /*Pin initialization of communication*/
    init_i2c_pin();

    /*I2C initialization*/
    initialize_i2c_master();

    /*The interrupt enable*/
    md_i2c_enable_it_evt(I2C1);

    while (1)
    {
        g_finish = 0;
        cnt = 40000;
        g_read_or_write = I2C_REQUEST_WRITE;
        /*Generate the start bit, automatically switch to host mode*/
        md_i2c_generate_start_condition(I2C1);
        while (g_finish != 1 && --cnt);
        md_delay_1ms(3000);
        
        g_finish = 0;
        cnt = 40000;
        g_read_or_write = I2C_REQUEST_READ;
        /*Generate the start bit, automatically switch to host mode*/
        md_i2c_generate_start_condition(I2C1);
        while (g_finish != 1 && --cnt);
        md_delay_1ms(1000);
    }
}

/**
  * @} Examples_I2C
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
