/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

#define I2C1_SCL_PORT   GPIOB
#define I2C1_SCL_PIN    MD_GPIO_PIN_10      /* I2CSCL:PB10 */
#define I2C1_SDA_PORT   GPIOB
#define I2C1_SDA_PIN    MD_GPIO_PIN_11      /* I2CSDA:PB11 */

/**
  * @brief Slave settings
  */
#define SLAVE_OWN_ADDRESS  0x5A /* This value is a left shift of a real 7 bits of a slave address
                                   value which can find in a Datasheet as example: b0101101
                                   mean in uint8_t equivalent at 0x2D and this value can be
                                   seen in the ADDR1 register in bits ADD[1:7] */

/**
  * @brief Master Transmission Request Direction Definition
  */
#define I2C_REQUEST_WRITE   0x00
#define I2C_REQUEST_READ    0x01

#define SLAVE_ADDR  0x2D

/* Exported Variables -------------------------------------------------------- */
extern volatile uint8_t g_read_or_write;
extern volatile uint8_t g_finish;
extern uint8_t  g_recv_buf[20];
extern uint8_t  g_send_buf[20];

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

__STATIC_INLINE void md_i2c_clear_flag_addr(I2C_TypeDef *i2c)
{
    __IO uint32_t tmpreg;
    tmpreg = i2c->STAT1;
    (void) tmpreg;
    tmpreg = i2c->STAT2;
    (void) tmpreg;
}

__STATIC_INLINE void md_i2c_clear_flag_stop(I2C_TypeDef *i2c)
{
    __IO uint32_t tmpreg;
    tmpreg = i2c->STAT1;
    (void) tmpreg;

    SET_BIT(i2c->CON1, I2C_CON1_PEN_MSK);
}

#endif     /*__MAIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
