/**********************************************************************************
 *
 * @file    usart.c
 * @brief   usart C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include "usart.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/* Private Variables --------------------------------------------------------- */
static usart_handle_t s_usart;
/* Private function prototypes ----------------------------------------------- */
static void init_usart_pin(void);

/* Private Macros ------------------------------------------------------------ */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/**
  * @brief  usart function
  * @retval None.
  */
void init_mcu_usart(void)
{
    init_usart_pin();

    s_usart.perh             = USART0;
    s_usart.init.mode        = USART_MODE_TX_RX;
    s_usart.init.baud        = 115200;       /*115200 8 1 N*/
    s_usart.init.word_length = USART_WORD_LENGTH_8B;
    s_usart.init.stop_bits   = USART_STOP_BITS_1;
    s_usart.init.parity      = USART_PARITY_NONE;
    s_usart.init.fctl        = USART_HW_FLOW_CTL_NONE;
    ald_usart_init(&s_usart);         /*Initialization and enabled UART0*/
}

/**
  * @brief  usart pin function
  * @retval None.
  */
static void init_usart_pin(void)
{
    gpio_init_t gpio_config;

    gpio_config.func = GPIO_FUNC_3;
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.type = GPIO_TYPE_CMOS;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    ald_gpio_init(GPIOA, GPIO_PIN_2, &gpio_config);     /*Initializes the UART0 TX pin*/

    gpio_config.mode = GPIO_MODE_INPUT;
    ald_gpio_init(GPIOA, GPIO_PIN_3, &gpio_config);     /*Apart from the pin direction for input configuration is the same as the UART0 TX pin*/
}

int fputc(int c, FILE *f)   /*Redirect printf output to the serial port*/
{
    while ((ald_usart_get_flag_status(&s_usart, USART_FLAG_TXE)) != SET) ;   /*Waiting on the completion of a byte*/

    s_usart.perh->DATA = (uint8_t)c;    /*UART send*/

    return c;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
