/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 July 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 July 2021    biyq          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "ebi_periph.h"
#include "string.h"

/* Private Macros ----------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */


/* Public Variables -------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */
/**
  * @brief  Setup the external memory controller.
  *         Called in startup_stm32f1xx_xx.s/.c before jump to main.
  *         This function configures the external SRAM mounted on STM3210E-EVAL
  *         board (STM32 High density devices). This SRAM will be used as program
  *         data memory (including heap and stack).
  * @param  None
  * @retval None
  * @retval Status.
  */
void ExtMemCtl(void)
{
    sram_handle_t sram_handle;
    nand_handle_t nand_handle;
    nand_address_t nand_addr;
    uint8_t  buf[0x840];
    uint32_t buffer[1];
    uint32_t index;
    const uint32_t PAGE_SIZE = 0x0840;
    const uint32_t PAGE_NUM = 0x10000;

    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
    ald_cmu_div_config(CMU_HCLK_2, CMU_DIV_1);

    /* copy data from nand flash to sram */
    for (index = 0U; index < PAGE_NUM * PAGE_SIZE; index += PAGE_SIZE)
    {
        /* copy data from Nand Flash to SRAM */
        nand_init(&nand_handle);
        nand_addr_get(index, &nand_addr);
        ald_nand_read_page_8b(&nand_handle, &nand_addr, buf, 1);
        ald_nand_read_sparearea_8b(&nand_handle, &nand_addr, buf + 0x800, 1);

        sram_init(&sram_handle);
        memcpy((void *)((uint8_t *)(0x64000000 + index)), (void *)buf, 0x840);
        /* check if the last 1 word is 0xFFFFFFFF */
        buffer[0] = (*((volatile uint32_t *)(0x64000000 + index + 0x840 - 1)));

        if (0xFFFFFFFF == buffer[0])
            break;
    }

    return;
}


/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
