/**********************************************************************************
 *
 * @file    ald_conf.h
 * @brief   Enable/Disable the peripheral module.
 *
 * @date    3 Aug 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          3 Aug 2021      biyq          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"
#include "stdio.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */


/* Private Constants --------------------------------------------------------- */


/* Private function prototypes ----------------------------------------------- */

/* Public function prototypes ----------------------------------------------- */
void uart_pin_init(void);
int uart_init(void);

/* Private Function ---------------------------------------------------------- */


/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_96M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 96000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    uart_pin_init();
    uart_init();

    printf("function uart_pin_init is at 0x%p\n", &uart_pin_init);
    printf("function uart_init is at 0x%p\n", &uart_init);

    while (1);
}


int fputc(int ch, FILE *f)
{
    uint32_t count = 0UL;
    uint8_t status = RESET;

    UART5->TXBUF = ch;

    do
    {
        status = UART5->RIF & (0x01UL << 14);
        count++;
    }
    while ((status == RESET) && (count != 0x1CE2));

    UART5->ICR = 0x01 << 14;

    if (count == 0x1CE2)
        return -1;
    else
        return 0;
}


/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
