/**********************************************************************************
 *
 * @file    ald_conf.h
 * @brief   Enable/Disable the peripheral module.
 *
 * @date    3 Aug 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          3 Aug 2021      biyq          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include "ald_conf.h"

/* Private Macros ----------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */


/* Public Variables -------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief define all needed pins for control EBI periph
  * @param  None.
  * @retval None.
  */
void ebisram_pin_init(void)
{
    gpio_init_t gpio_config;

    gpio_config.mode  = GPIO_MODE_OUTPUT;
    gpio_config.odos  = GPIO_PUSH_PULL;
    gpio_config.pupd  = GPIO_PUSH_UP;
    gpio_config.nodrv = GPIO_OUT_DRIVE_1;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.flt   = GPIO_FILTER_DISABLE;
    gpio_config.type  = GPIO_TYPE_TTL;
    gpio_config.func  = GPIO_FUNC_7;

    /*初始化EBI地址管脚*/
    ald_gpio_init(GPIOC, GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3, &gpio_config);
    ald_gpio_init(GPIOA, GPIO_PIN_4 | GPIO_PIN_5 | GPIO_PIN_6 | GPIO_PIN_7, &gpio_config);
    ald_gpio_init(GPIOC, GPIO_PIN_4 | GPIO_PIN_5, &gpio_config);
    ald_gpio_init(GPIOD, GPIO_PIN_11 | GPIO_PIN_12 | GPIO_PIN_13, &gpio_config);
    ald_gpio_init(GPIOE, GPIO_PIN_3 | GPIO_PIN_4 | GPIO_PIN_5 | GPIO_PIN_6 | GPIO_PIN_2, &gpio_config);
    ald_gpio_init(GPIOB, GPIO_PIN_5 | GPIO_PIN_6 | GPIO_PIN_10 | GPIO_PIN_11
                  | GPIO_PIN_12 | GPIO_PIN_13 | GPIO_PIN_14 | GPIO_PIN_15, &gpio_config);

    /*初始化EBI数据管脚(与EBI地址管脚配置相同)*/
    ald_gpio_init(GPIOD, GPIO_PIN_14 | GPIO_PIN_15 | GPIO_PIN_0 | GPIO_PIN_1
                  | GPIO_PIN_8 | GPIO_PIN_9 | GPIO_PIN_10, &gpio_config);
    ald_gpio_init(GPIOE, GPIO_PIN_7 | GPIO_PIN_8 | GPIO_PIN_9 | GPIO_PIN_10
                  | GPIO_PIN_11 | GPIO_PIN_12 | GPIO_PIN_13 | GPIO_PIN_14 | GPIO_PIN_15, &gpio_config);

    /*初始化EBI控制管脚(与EBI地址管脚配置相同)*/
    ald_gpio_init(GPIOC, GPIO_PIN_10, &gpio_config);     /*EBI_NE2*/
    ald_gpio_init(GPIOD, GPIO_PIN_5, &gpio_config);      /*EBI_NWE*/
    ald_gpio_init(GPIOD, GPIO_PIN_4, &gpio_config);      /*EBI_NOE*/
    ald_gpio_init(GPIOE, GPIO_PIN_0, &gpio_config);      /*EBI_NBL0*/
    ald_gpio_init(GPIOE, GPIO_PIN_1, &gpio_config);      /*EBI_NBL1*/
}

/* Public Function---------------------------------------------------------- */
/**
  * @brief sram_init
  * @param  None.
  * @retval None.
  */
void sram_init(sram_handle_t *h_sram_t)
{
    ald_ebi_nor_sram_timing_t ebi_timing;

    ebisram_pin_init();

    h_sram_t->instance       = EBI_NOR_SRAM_DEVICE;
    h_sram_t->ext            = EBI_NOR_SRAM_EXTENDED_DEVICE;
    ebi_timing.data_setup     = ((ald_cmu_get_hclk2_clock()) / 12500000);   /*数据保持时间 = ((80 * (ald_cmu_get_hclk2_clock())) / 1000000000) - 1*/
    ebi_timing.data_setup     = (ebi_timing.data_setup > 0x01) ? (ebi_timing.data_setup - 1) : 0x01;
    ebi_timing.addr_setup     = 1;
    ebi_timing.addr_hold      = 1;   /*不复用*/
    ebi_timing.bus_dur        = 2;   /*异步写和读之间需要2个EBI时钟恢复*/
    ebi_timing.div            = 2;   /*在异步NOR Flash,SRAM,PSRAM中，无效*/
    ebi_timing.latency        = 5;   /*在异步NOR Flash,SRAM,PSRAM中，无效*/
    ebi_timing.mode           = EBI_ACCESS_MODE_A;
    h_sram_t->init.bank      = EBI_NORSRAM_BANK2;
    h_sram_t->init.mux       = EBI_DATA_ADDRESS_MUX_DISABLE;
    h_sram_t->init.type      = EBI_MEMORY_TYPE_SRAM;
    h_sram_t->init.width     = EBI_NORSRAM_MEM_BUS_WIDTH_16;
    h_sram_t->init.acc_mode  = EBI_BURST_ACCESS_MODE_DISABLE;
    h_sram_t->init.polarity  = EBI_WAIT_SIGNAL_POLARITY_LOW;
    h_sram_t->init.wrap_mode = EBI_WRAP_MODE_DISABLE;
    h_sram_t->init.active    = EBI_WAIT_TIMING_BEFORE_WS;
    h_sram_t->init.write     = EBI_WRITE_OPERATION_ENABLE;
    h_sram_t->init.signal    = EBI_WAIT_SIGNAL_DISABLE;
    h_sram_t->init.ext_mode  = EBI_EXTENDED_MODE_DISABLE;
    h_sram_t->init.wait      = EBI_ASYNCHRONOUS_WAIT_DISABLE;
    h_sram_t->init.burst     = EBI_WRITE_BURST_DISABLE;

    ald_sram_init(h_sram_t, &ebi_timing, &ebi_timing);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
