/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    31 July 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          31 July 2021    biyq          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "es32f36xx.h"
#include "ald_conf.h"
#include "string.h"

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */


/* Public Variables ---------------------------------------------------------- */

/* Public function prototypes ----------------------------------------------- */


/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
void uart_pin_init(void)
{
    gpio_init_t gpio_config;
    memset(&gpio_config, 0x00, sizeof(gpio_init_t));

    /* Initialize tx pin: PB9 */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_TTL;
    gpio_config.func = GPIO_FUNC_4;
    ald_gpio_init(GPIOB, GPIO_PIN_9, &gpio_config);

    /* Initialize rx pin: PB8 */
    gpio_config.mode = GPIO_MODE_INPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_TTL;
    gpio_config.func = GPIO_FUNC_4;
    ald_gpio_init(GPIOB, GPIO_PIN_8, &gpio_config);

    return;
}

/**
  * @brief  initialization function to init UART1
  * @retval Status.
  */
int uart_init(void)
{
    uart_handle_t uart_handle;
    /* Initialize ALD */
    ald_cmu_perh_clock_config(CMU_PERH_UART5, ENABLE);

    /* Initialize pin */
    uart_pin_init();

    memset(&uart_handle, 0x00, sizeof(uart_handle_t));
    /* Initialize uart */
    uart_handle.perh             = UART5;
    uart_handle.init.baud        = 115200;
    uart_handle.init.word_length = UART_WORD_LENGTH_8B;
    uart_handle.init.stop_bits   = UART_STOP_BITS_1;
    uart_handle.init.parity      = UART_PARITY_NONE;
    uart_handle.init.mode        = UART_MODE_UART;
    uart_handle.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&uart_handle);

    ald_uart_tx_fifo_config(&uart_handle, UART_TXFIFO_EMPTY);

    return 0;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
