/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    zhuxf          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include <stdio.h>
#include "main.h"


/* Private Macros ----------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */

/* Public Variables -------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    uint16_t x = 0U, y = 150U;
    uint16_t dirx = 0U, diry = 0U;

    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);    /*使能倍频，由晶振三分频倍频至72MHz*/
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);    /*选择倍频时钟为系统时钟*/
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);    /*使能所有外设时钟*/

    ald_cmu_div_config(CMU_HCLK_2, CMU_DIV_1);

    mcu_ebi_init();     /*初始化EBI模块*/
    lcd_init();

    lcd_set_background(0, 0, WIDTH, 150, 0xC0C0C0);
    lcd_show_string(50, 50, 380, 48, "Essemi LCD example... |^_^|", 0xFF0000, C2412, BG_OFF, 0);
    lcd_set_background(0, 150, WIDTH, HEIGHT - 150, 0xFFFFFF);

    while (1)
    {
        lcd_draw_image(x, y, 240, 140, (uint16_t *)gImage_image);

        if (dirx == 0)
        {
            x += 1;

            if (x >= (WIDTH - 240))
                dirx = 1;
        }
        else
        {
            x -= 1;

            if (x <= 0)
                dirx = 0;
        }

        if (diry == 0)
        {
            y += 1;

            if (y >= HEIGHT - 140)
                diry = 1;
        }
        else
        {
            y -= 1;

            if (y <= 150)
                diry = 0;
        }
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
