/**********************************************************************************
 *
 * @file    lcd_driver.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    zhuxf          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FLASH_H__
#define   __FLASH_H__

/* Includes ---------------------------------------------------------------- */

#include "utils.h"
#include "ald_gpio.h"
#include "ald_ebi.h"
#include "ald_nor_lcd.h"
#include "ald_dma.h"
#include "ald_cmu.h"
#include "image.h"


/* Exported Types ---------------------------------------------------------- */

typedef struct
{
    volatile uint16_t REG;
    volatile uint16_t RAM;
} LCD_TypeDef_t;

typedef enum
{
    C1206 = 12,
    C1608 = 16,
    C2412 = 24,
} char_size_t;

typedef enum
{
    BG_ON = 0,
    BG_OFF,
} char_bg_t;

/* Exported Macros ----------------------------------------------------------- */

/*使用NOR/PSRAM3子组，以A0作为命令/数据的选择线*/
/*注意16bit模式下EBI模块内部会自动把地址右移一位送到外部地址线*/
#define LCD ((LCD_TypeDef_t *)(0x68000000))

#define WIDTH   480
#define HEIGHT  800

#define LCD_SET_REG(LCD_REG)    (LCD->REG = (LCD_REG))
#define LCD_SET_RAM(LCD_RAM)    (LCD->RAM = (LCD_RAM))

#define LCD_READ_RAM()   (LCD->RAM)

#define LCD_WRRAM_PREPARE()     (LCD->REG = 0x2C00)

#define GET_RGB565_FROM_RGB888(RGB888) \
    ((((RGB888) & 0xF80000))>>8 | (((RGB888) & 0x00FC00))>>5 | ((RGB888) & 0x0000F8)>>3)

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */

void mcu_ebisram_init(void);
void lcd_init(void);
void lcd_write_reg(uint16_t reg, uint16_t para);
uint8_t lcd_read_ram(uint16_t reg);
uint8_t lcd_read_reg(uint16_t reg);
void lcd_set_background(uint16_t x, uint16_t y, uint16_t width, uint16_t height, \
                        uint32_t rgb888);
void lcd_draw_image(uint16_t xstart, uint16_t xend, \
                    uint16_t ystart, uint16_t yend, uint16_t *addr);

void lcd_show_char(uint16_t x, uint16_t y, char ch, char_size_t size, \
                   uint32_t rgb_ch, char_bg_t bg, uint32_t rgb_bg);
void lcd_show_string(uint16_t x, uint16_t y, uint16_t width, uint16_t height, \
                     char *p, uint32_t color, char_size_t size, \
                     char_bg_t bg, uint32_t rgb_bg);

#endif /* __FLASH_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
