/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    zhuxf          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "utils.h"
#include <string.h>
#include "ald_conf.h"

#define     EBI_NAND_DATA_PORTn         8
#define     EBI_NAND_DATA_PINn          8

#define     EBI_D0_PORT         GPIOD
#define     EBI_D0_PIN          GPIO_PIN_14
#define     EBI_D1_PORT         GPIOD
#define     EBI_D1_PIN          GPIO_PIN_15
#define     EBI_D2_PORT         GPIOD
#define     EBI_D2_PIN          GPIO_PIN_0
#define     EBI_D3_PORT         GPIOD
#define     EBI_D3_PIN          GPIO_PIN_1
#define     EBI_D4_PORT         GPIOE
#define     EBI_D4_PIN          GPIO_PIN_7
#define     EBI_D5_PORT         GPIOE
#define     EBI_D5_PIN          GPIO_PIN_8
#define     EBI_D6_PORT         GPIOE
#define     EBI_D6_PIN          GPIO_PIN_9
#define     EBI_D7_PORT         GPIOE
#define     EBI_D7_PIN          GPIO_PIN_10

#define     EBI_NCE2_PORT           GPIOD
#define     EBI_NCE2_PIN            GPIO_PIN_7

#define     EBI_NOE_PORT            GPIOD
#define     EBI_NOE_PIN         GPIO_PIN_4
#define     EBI_NWE_PORT            GPIOD
#define     EBI_NWE_PIN         GPIO_PIN_5
#define     EBI_NWAIT_PORT          GPIOD
#define     EBI_NWAIT_PIN           GPIO_PIN_6

#define     EBI_CLE_PORT            GPIOD
#define     EBI_CLE_PIN         GPIO_PIN_11

#define     EBI_ALE_PORT            GPIOD
#define     EBI_ALE_PIN         GPIO_PIN_12

GPIO_TypeDef *EBI_DATA_PORT[EBI_NAND_DATA_PORTn] =
{
    EBI_D0_PORT, EBI_D1_PORT,
    EBI_D2_PORT, EBI_D3_PORT,
    EBI_D4_PORT, EBI_D5_PORT,
    EBI_D6_PORT, EBI_D7_PORT
};

const uint16_t EBI_DATA_PIN[EBI_NAND_DATA_PINn] =
{
    EBI_D0_PIN, EBI_D1_PIN,
    EBI_D2_PIN, EBI_D3_PIN,
    EBI_D4_PIN, EBI_D5_PIN,
    EBI_D6_PIN, EBI_D7_PIN
};



#endif

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
