/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    zhuxf          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include <stdio.h>
#include "main.h"

/* Private Macros ----------------------------------------------------------- */

#define SRAM_BANK_ADDR  0x64000000
#define WRITE_READ_ADDR 0x0400

/* Private Variables--------------------------------------------------------- */

/* Public Variables -------------------------------------------------------- */ 
char g_sram_txbuf[] = "essemi mcu ebi sram example!";
char g_sram_rxbuf[sizeof(g_sram_txbuf)];

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    uint32_t idx;

    /* Configure system clock */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);    /*使能倍频，由晶振三分频倍频至72MHz*/
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);    /*选择倍频时钟为系统时钟*/
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);    /*使能所有外设时钟*/

    ald_cmu_div_config(CMU_HCLK_2, CMU_DIV_1);

    /* mcu_uart_init();      初始化UART模块 */
    mcu_ebisram_init();     /*初始化EBI SRAM模块*/

    /* printf("The date written to ebi sram is -> %s\r\n", s_sram_txbuf); */

    for (idx = 0; idx < sizeof(g_sram_txbuf); idx++)  /*向sram指定地址处写数据*/
    {
        *(volatile uint8_t *)(SRAM_BANK_ADDR + idx) = g_sram_txbuf[idx];
    }

    for (idx = 0; idx < sizeof(g_sram_txbuf); idx++)   /*读sram指定地址处数据*/
    {
        g_sram_rxbuf[idx] = *(volatile uint8_t *)(SRAM_BANK_ADDR + idx);
    }

    /* printf("The data read from ebi sram is  -> %s\r\n", s_sram_rxbuf); */

    /*     if (!memcmp(s_sram_txbuf, s_sram_rxbuf, sizeof(s_sram_txbuf)))       比较写入和读出的数据
              printf("Read OK!\r\n");
          else
      printf("Read ERROR!\r\n"); */

    while (1)
    {
        ald_delay_ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
