/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Private Constants --------------------------------------------------------- */

/* Private Variables --------------------------------------------------------- */
static md_dma_descriptor_t s_dma0_ctrl_base[1] __attribute__((aligned(512)));

/* Public Variables ---------------------------------------------------------- */
char g_src_buf[64] = "hello world!";
char g_dst_buf[64] = {0};

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint16_t cnt = 4000U;
    md_dma_config_t dma_config;

    /* Configure system clock */
    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);

    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* 2bits preempt-priority(0-3)
       2bits sub-priority(0-3). */
    NVIC_SetPriorityGrouping(5);

    memset(s_dma0_ctrl_base, 0x0, sizeof(s_dma0_ctrl_base));
    memset(&dma_config, 0x0, sizeof(md_dma_config_t));

    md_dma_set_ctrlbase((uint32_t)s_dma0_ctrl_base);
    md_dma_enable();
    md_dma_config_struct(&dma_config);

    dma_config.channel = 0;
    dma_config.dst     = g_dst_buf;
    dma_config.src     = g_src_buf;
    dma_config.size    = strlen(g_src_buf);
    dma_config.burst   = DISABLE;

    md_dma_config_base(DMA0, MD_DMA_CYCLE_CTRL_AUTO, &dma_config);
    md_dma_enable_channel(MD_DMA_CH_0);
    md_dma_enable_soft_req(MD_DMA_CH_0);

    while (!md_dma_is_active_flag_done(MD_DMA_CH_0) && (--cnt));

    while (1)
    {
        md_delay_1ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
